/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.Normalizer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.admin.domain.AbstractDomainService;
import org.silverpeas.core.admin.domain.exception.DomainAuthenticationPropertiesAlreadyExistsException;
import org.silverpeas.core.admin.domain.exception.DomainConflictException;
import org.silverpeas.core.admin.domain.exception.DomainCreationException;
import org.silverpeas.core.admin.domain.exception.DomainDeletionException;
import org.silverpeas.core.admin.domain.exception.DomainPropertiesAlreadyExistsException;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.domain.repository.SQLDomainRepository;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Named(value="sqlDomainService")
public class SQLDomainService
extends AbstractDomainService {
    SettingBundle templateSettings;
    SettingBundle adminSettings;
    private static final String DATABASE_TABLE_NAME_DOMAIN_PREFIX = "Domain";
    private static final String DATABASE_TABLE_NAME_DOMAIN_USER_SUFFIX = "_User";
    private static final String DATABASE_TABLE_NAME_DOMAIN_GROUP_SUFFIX = "_Group";
    private static final String DATABASE_TABLE_NAME_DOMAIN_USER_GROUP_SUFFIX = "_Group_User_Rel";
    @Inject
    private SQLDomainRepository dao;

    @PostConstruct
    void init() {
        this.templateSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.domains.templateDomainSQL");
        this.adminSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.admin.admin");
    }

    private void checkFileName(String fileDomainName) throws DomainAuthenticationPropertiesAlreadyExistsException, DomainPropertiesAlreadyExistsException {
        String authenticationPropertiesPath = FileRepositoryManager.getDomainAuthenticationPropertiesPath(fileDomainName);
        String domainPropertiesPath = FileRepositoryManager.getDomainPropertiesPath(fileDomainName);
        if (new File(authenticationPropertiesPath).exists()) {
            throw new DomainAuthenticationPropertiesAlreadyExistsException(fileDomainName);
        }
        if (new File(domainPropertiesPath).exists()) {
            throw new DomainPropertiesAlreadyExistsException(fileDomainName);
        }
    }

    protected String getTechnicalDomainName(Domain domain) {
        String fileDomainName = FileServerUtils.replaceAccentChars(domain.getName());
        fileDomainName = Normalizer.normalize(fileDomainName, Normalizer.Form.NFKD);
        fileDomainName = fileDomainName.replaceAll("[^\\p{Alnum}]+", "");
        int maxLength = SQLDomainService.getMaxLength(domain);
        return domain.getId() + StringUtils.left((String)fileDomainName, (int)maxLength);
    }

    private static int getMaxLength(Domain domain) {
        int maxTableNameSuffixLength = Math.max(DATABASE_TABLE_NAME_DOMAIN_USER_SUFFIX.length(), DATABASE_TABLE_NAME_DOMAIN_GROUP_SUFFIX.length());
        maxTableNameSuffixLength = Math.max(maxTableNameSuffixLength, DATABASE_TABLE_NAME_DOMAIN_USER_GROUP_SUFFIX.length());
        return 30 - DATABASE_TABLE_NAME_DOMAIN_PREFIX.length() - maxTableNameSuffixLength - domain.getId().length();
    }

    @Override
    @Transactional
    public String createDomain(Domain domainToCreate) throws DomainConflictException, DomainCreationException {
        String initialDomainName = domainToCreate.getName();
        try {
            this.checkDomainName(initialDomainName);
        }
        catch (AdminException e) {
            throw new DomainConflictException("SQLDomainService.createDomain", domainToCreate.toString(), (Exception)((Object)e));
        }
        String domainId = this.getNextDomainId();
        domainToCreate.setId(domainId);
        String technicalDomainName = this.getTechnicalDomainName(domainToCreate);
        this.checkFileName(technicalDomainName);
        try {
            domainToCreate.setName(technicalDomainName);
            this.generateDomainPropertiesFile(domainToCreate);
            this.generateDomainAuthenticationPropertiesFile(domainToCreate);
            this.dao.createDomainStorage(domainToCreate);
            if (!StringUtil.isDefined((String)domainToCreate.getDriverClassName())) {
                domainToCreate.setDriverClassName("org.silverpeas.core.admin.domain.driver.sqldriver.SQLDriver");
            }
            domainToCreate.setPropFileName("org.silverpeas.domains.domain" + technicalDomainName);
            domainToCreate.setAuthenticationServer("autDomain" + technicalDomainName);
            domainToCreate.setName(initialDomainName);
            this.registerDomain(domainToCreate);
        }
        catch (DomainCreationException e) {
            this.rollBack(domainToCreate, initialDomainName, technicalDomainName);
            throw e;
        }
        catch (Exception e) {
            this.rollBack(domainToCreate, initialDomainName, technicalDomainName);
            throw new DomainCreationException(domainToCreate.toString(), e);
        }
        return domainId;
    }

    private void rollBack(Domain domainToCreate, String initialDomainName, String technicalDomainName) {
        try {
            this.removePropertiesFiles(technicalDomainName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            domainToCreate.setName(technicalDomainName);
            this.dao.deleteDomainStorage(domainToCreate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            domainToCreate.setName(initialDomainName);
            this.unRegisterDomain(domainToCreate);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Transactional
    public String deleteDomain(Domain domainToRemove) throws DomainDeletionException {
        String domainId;
        String originalName = domainToRemove.getName();
        String fileDomainName = SQLDomainService.getFileDomainName(domainToRemove);
        domainToRemove.setName(fileDomainName);
        try {
            domainId = this.unRegisterDomain(domainToRemove);
        }
        catch (DomainDeletionException e) {
            domainToRemove.setName(originalName);
            throw e;
        }
        if (!StringUtil.isDefined((String)domainId)) {
            domainToRemove.setName(originalName);
            throw new DomainDeletionException("SQLDomainService.deleteDomain", new String[0]);
        }
        try {
            this.dao.deleteDomainStorage(domainToRemove);
        }
        catch (Exception e) {
            domainToRemove.setName(originalName);
            throw new DomainDeletionException("SQLDomainService.deleteDomain", e);
        }
        this.removeDomainPropertiesFile(domainToRemove);
        return domainId;
    }

    private static String getFileDomainName(Domain domainToRemove) {
        String separator = "#@#@#@#@#";
        String domainPropertyPrefix = new File(FileRepositoryManager.getDomainPropertiesPath(separator).replaceAll(separator + ".*$", "")).getName();
        String domainPropertyFileName = domainToRemove.getPropFileName().replaceAll("\\p{Alnum}+\\.+", "");
        return domainPropertyFileName.replaceFirst(domainPropertyPrefix, "");
    }

    private void removePropertiesFiles(String domainName) {
        String authenticationPropertiesPath = FileRepositoryManager.getDomainAuthenticationPropertiesPath(domainName);
        String domainPropertiesPath = FileRepositoryManager.getDomainPropertiesPath(domainName);
        try {
            Files.deleteIfExists(Paths.get(authenticationPropertiesPath, new String[0]));
            Files.deleteIfExists(Paths.get(domainPropertiesPath, new String[0]));
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).warn(e.getMessage(), new Object[0]);
        }
    }

    private void generateDomainPropertiesFile(Domain domainToCreate) throws DomainCreationException {
        String domainName = domainToCreate.getName();
        String domainPropertiesPath = FileRepositoryManager.getDomainPropertiesPath(domainName);
        SilverpeasTemplate template = this.getNewTemplate();
        template.setAttribute("SQLDataSourceJNDIName", (Object)this.adminSettings.getString("DefaultDataSourceJNDIName"));
        template.setAttribute("SQLUserTableName", (Object)(DATABASE_TABLE_NAME_DOMAIN_PREFIX + domainName + DATABASE_TABLE_NAME_DOMAIN_USER_SUFFIX));
        template.setAttribute("SQLGroupTableName", (Object)(DATABASE_TABLE_NAME_DOMAIN_PREFIX + domainName + DATABASE_TABLE_NAME_DOMAIN_GROUP_SUFFIX));
        template.setAttribute("SQLUserGroupTableName", (Object)(DATABASE_TABLE_NAME_DOMAIN_PREFIX + domainName + DATABASE_TABLE_NAME_DOMAIN_USER_GROUP_SUFFIX));
        File domainPropertiesFile = new File(domainPropertiesPath);
        try (PrintWriter out = new PrintWriter(new FileWriter(domainPropertiesFile));){
            out.print(template.applyFileTemplate("templateDomainSQL"));
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(domainPropertiesFile.toPath());
            }
            catch (IOException ioe) {
                SilverLogger.getLogger((Object)this).warn(ioe.getMessage(), new Object[0]);
            }
            throw new DomainCreationException(domainToCreate.toString(), e);
        }
    }

    private void generateDomainAuthenticationPropertiesFile(Domain domainToCreate) throws DomainCreationException {
        String domainName = domainToCreate.getName();
        String domainPropertiesPath = FileRepositoryManager.getDomainPropertiesPath(domainName);
        String authenticationPropertiesPath = FileRepositoryManager.getDomainAuthenticationPropertiesPath(domainName);
        boolean allowPasswordChange = this.templateSettings.getBoolean("allowPasswordChange", true);
        SilverpeasTemplate template = this.getNewTemplate();
        template.setAttribute("allowPasswordChange", (Object)allowPasswordChange);
        template.setAttribute("SQLDataSourceJNDIName", (Object)this.adminSettings.getString("DefaultDataSourceJNDIName"));
        template.setAttribute("SQLUserTableName", (Object)(DATABASE_TABLE_NAME_DOMAIN_PREFIX + domainName + DATABASE_TABLE_NAME_DOMAIN_USER_SUFFIX));
        File domainPropertiesFile = new File(domainPropertiesPath);
        File authenticationPropertiesFile = new File(authenticationPropertiesPath);
        try (PrintWriter out = new PrintWriter(new FileWriter(authenticationPropertiesFile));){
            out.print(template.applyFileTemplate("templateDomainAuthenticationSQL"));
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(authenticationPropertiesFile.toPath());
                Files.deleteIfExists(domainPropertiesFile.toPath());
            }
            catch (IOException ioe) {
                SilverLogger.getLogger((Object)this).warn(ioe.getMessage(), new Object[0]);
            }
            throw new DomainCreationException(domainToCreate.toString(), e);
        }
    }

    private void removeDomainPropertiesFile(Domain domainToRemove) {
        String domainName = domainToRemove.getName();
        String domainPropertiesPath = FileRepositoryManager.getDomainPropertiesPath(domainName);
        String authenticationPropertiesPath = FileRepositoryManager.getDomainAuthenticationPropertiesPath(domainName);
        File domainPropertiesFile = new File(domainPropertiesPath);
        File authenticationPropertiesFile = new File(authenticationPropertiesPath);
        try {
            Files.deleteIfExists(domainPropertiesFile.toPath());
            Files.deleteIfExists(authenticationPropertiesFile.toPath());
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).warn("Domain or authentication properties file no deleted. Domain properties: " + domainPropertiesPath + ", authentication properties: " + authenticationPropertiesPath, new Object[0]);
        }
    }

    private SilverpeasTemplate getNewTemplate() {
        return SilverpeasTemplates.createSilverpeasTemplateOnCore((String)"admin/sqlDomain");
    }
}

