/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.AbstractDomainDriver;
import org.silverpeas.core.admin.domain.DomainDriver;
import org.silverpeas.core.admin.domain.DomainDriverProvider;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.persistence.DomainRow;
import org.silverpeas.core.admin.persistence.KeyStoreRow;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdminNotFoundException;
import org.silverpeas.core.admin.user.UserIndexation;
import org.silverpeas.core.admin.user.dao.GroupDAO;
import org.silverpeas.core.admin.user.dao.UserDAO;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.Level;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Transactional(value=Transactional.TxType.MANDATORY)
public class DomainDriverManager
extends AbstractDomainDriver {
    public static final String DOMAIN = "domain";
    public static final String GROUP = "group";
    private static final String USERS = "users";
    @Inject
    private UserDAO userDAO;
    @Inject
    private GroupDAO groupDAO;
    @Inject
    private OrganizationSchema organizationSchema;
    private final Map<String, DomainDriver> domainDriverInstances = new ConcurrentHashMap<String, DomainDriver>();

    protected DomainDriverManager() {
    }

    @Override
    public String createUser(UserDetail user) throws AdminException {
        try {
            DomainDriver domainDriver = this.getDomainDriver(user.getDomainId());
            return domainDriver.createUser(user);
        }
        catch (AdminException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)"user", (Object)user.getDisplayedName()), (Throwable)((Object)e));
        }
    }

    @Override
    public UserDetail importUser(String userLogin) throws AdminException {
        return null;
    }

    @Override
    public void removeUser(String userId) throws AdminException {
    }

    @Override
    public UserDetail synchroUser(String userId) throws AdminException {
        return null;
    }

    @Override
    public void deleteUser(String userId) throws AdminException {
        try (Connection connection = DBUtil.openConnection();){
            UserDetail user = this.userDAO.getUserById(connection, userId);
            if (user == null) {
                throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)"user", (Object)userId), new String[0]);
            }
            DomainDriver domainDriver = this.getDomainDriver(user.getDomainId());
            domainDriver.deleteUser(user.getSpecificId());
            this.unindexUser(userId);
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)"user", (Object)userId), e);
        }
    }

    @Override
    public void updateUserDetail(UserDetail user) throws AdminException {
        try {
            DomainDriver domainDriver = this.getDomainDriver(user.getDomainId());
            domainDriver.updateUserDetail(user);
        }
        catch (AdminException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"user", (Object)user.getId()), (Throwable)((Object)e));
        }
    }

    @Override
    public UserDetail getUser(String specificId) throws AdminException {
        return null;
    }

    @Override
    public List<UserDetail> listUsers(Collection<String> specificIds) throws AdminException {
        return Collections.emptyList();
    }

    @Override
    public void updateUserFull(UserFull user) throws AdminException {
        try {
            DomainDriver domainDriver = this.getDomainDriver(user.getDomainId());
            domainDriver.updateUserFull(user);
            this.indexUser(user.getId());
        }
        catch (AdminException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"user", (Object)user.getId()), (Throwable)((Object)e));
        }
    }

    private String[] getUserIdsOfDomain(String domainId) throws AdminException {
        String[] stringArray;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<String> userIds = this.userDAO.getUserIdsInDomain(connection, domainId);
                stringArray = userIds.toArray(new String[0]);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"user in domain", (Object)domainId), e);
                }
            }
            connection.close();
        }
        return stringArray;
    }

    /*
     * Loose catch block
     */
    private <T extends UserDetail> List<T> loadUserEntities(Collection<String> userIds, Class<T> userModelClass) throws AdminException {
        SilverLogger logger;
        List list;
        Connection connection;
        long applyingSpDataToDomainUsersTime;
        long nbDomainUsersFetched;
        long fetchingDomainUsersTime;
        long nbDomainsFetched;
        long fetchingDomainTime;
        long nbSpUsersFetched;
        long fetchingSpUsersTime;
        long startTime;
        block14: {
            startTime = System.currentTimeMillis();
            fetchingSpUsersTime = 0L;
            nbSpUsersFetched = 0L;
            fetchingDomainTime = 0L;
            nbDomainsFetched = 0L;
            fetchingDomainUsersTime = 0L;
            nbDomainUsersFetched = 0L;
            applyingSpDataToDomainUsersTime = 0L;
            boolean isUserFull = userModelClass == UserFull.class;
            connection = DBUtil.openConnection();
            long tmpStart = System.currentTimeMillis();
            List<UserDetail> silverpeasUsers = this.userDAO.getUserByIds(connection, userIds);
            if (silverpeasUsers.size() != userIds.size()) {
                throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)USERS, userIds), new String[0]);
            }
            fetchingSpUsersTime = System.currentTimeMillis() - tmpStart;
            nbSpUsersFetched = silverpeasUsers.size();
            tmpStart = System.currentTimeMillis();
            HashMap<String, Pair> domainsById = new HashMap<String, Pair>();
            for (UserDetail spUser : silverpeasUsers) {
                String domainId = spUser.getDomainId();
                if (domainsById.containsKey(domainId)) continue;
                domainsById.put(domainId, Pair.of((Object)domainId, (Object)this.getDomainDriver(domainId)));
            }
            fetchingDomainTime = System.currentTimeMillis() - tmpStart;
            nbDomainsFetched = domainsById.size();
            tmpStart = System.currentTimeMillis();
            Map<String, UserDetail> domainUsersBySpecificId = silverpeasUsers.stream().collect(Collectors.groupingBy(u -> (Pair)domainsById.get(u.getDomainId()), Collectors.mapping(u -> u, Collectors.toList()))).entrySet().stream().flatMap(e -> this.toUsersFromDomain((List)e.getValue(), isUserFull, (Pair<String, DomainDriver>)((Pair)e.getKey())).stream()).collect(Collectors.toMap(u -> String.format("%s@%s", u.getSpecificId(), u.getDomainId()), u -> u));
            fetchingDomainUsersTime = System.currentTimeMillis() - tmpStart;
            nbDomainUsersFetched = domainUsersBySpecificId.size();
            tmpStart = System.currentTimeMillis();
            List users = silverpeasUsers.stream().map(u -> {
                UserDetail user = (UserDetail)domainUsersBySpecificId.get(String.format("%s@%s", u.getSpecificId(), u.getDomainId()));
                if (user == null) {
                    SilverLogger.getLogger((Object)this).error("Cannot find user " + u.getSpecificId() + " in domain " + u.getDomainId(), new Object[0]);
                    return null;
                }
                user.setLogin(u.getLogin());
                user.setId(u.getId());
                user.setSpecificId(u.getSpecificId());
                user.setDomainId(u.getDomainId());
                user.setAccessLevel(u.getAccessLevel());
                user.setCreationDate(u.getCreationDate());
                user.setSaveDate(u.getSaveDate());
                user.setVersion(u.getVersion());
                user.setTosAcceptanceDate(u.getTosAcceptanceDate());
                user.setLastLoginDate(u.getLastLoginDate());
                user.setNbSuccessfulLoginAttempts(u.getNbSuccessfulLoginAttempts());
                user.setLastLoginCredentialUpdateDate(u.getLastLoginCredentialUpdateDate());
                user.setExpirationDate(u.getExpirationDate());
                user.setState(u.getState());
                user.setStateSaveDate(u.getStateSaveDate());
                user.setNotifManualReceiverLimit(u.getNotifManualReceiverLimit());
                user.setSensitiveData(u.hasSensitiveData());
                if (isUserFull) {
                    user.setLoginQuestion(u.getLoginQuestion());
                    user.setLoginAnswer(u.getLoginAnswer());
                }
                return user;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            applyingSpDataToDomainUsersTime = System.currentTimeMillis() - tmpStart;
            list = users;
            if (connection == null) break block14;
            connection.close();
        }
        if ((logger = SilverLogger.getLogger((Object)this)).isLoggable(Level.DEBUG)) {
            logger.debug(String.format("Fetching %s %s instances in %s:%n\t- fetching %s Silverpeas's users in %s%n\t- fetching %s domains in %s%n\t- fetching %s domain users in %s%n\t- applying Silverpeas's user date to domain users in %s", userIds.size(), userModelClass.getSimpleName(), DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - startTime)), nbSpUsersFetched, DurationFormatUtils.formatDurationHMS((long)fetchingSpUsersTime), nbDomainsFetched, DurationFormatUtils.formatDurationHMS((long)fetchingDomainTime), nbDomainUsersFetched, DurationFormatUtils.formatDurationHMS((long)fetchingDomainUsersTime), DurationFormatUtils.formatDurationHMS((long)applyingSpDataToDomainUsersTime)), new Object[0]);
        }
        return list;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e2) {
                        throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)USERS, userIds), e2);
                    }
                }
                catch (Throwable throwable3) {
                    SilverLogger logger2 = SilverLogger.getLogger((Object)this);
                    if (logger2.isLoggable(Level.DEBUG)) {
                        logger2.debug(String.format("Fetching %s %s instances in %s:%n\t- fetching %s Silverpeas's users in %s%n\t- fetching %s domains in %s%n\t- fetching %s domain users in %s%n\t- applying Silverpeas's user date to domain users in %s", userIds.size(), userModelClass.getSimpleName(), DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - startTime)), nbSpUsersFetched, DurationFormatUtils.formatDurationHMS((long)fetchingSpUsersTime), nbDomainsFetched, DurationFormatUtils.formatDurationHMS((long)fetchingDomainTime), nbDomainUsersFetched, DurationFormatUtils.formatDurationHMS((long)fetchingDomainUsersTime), DurationFormatUtils.formatDurationHMS((long)applyingSpDataToDomainUsersTime)), new Object[0]);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private <T extends UserDetail> List<T> toUsersFromDomain(List<UserDetail> silverpeasUsers, boolean isUserFull, Pair<String, DomainDriver> domainDriver) {
        Set<String> specificIds = silverpeasUsers.stream().map(UserDetail::getSpecificId).collect(Collectors.toSet());
        String identifier = (String)domainDriver.getFirst();
        DomainDriver driver = (DomainDriver)domainDriver.getSecond();
        Mutable domainUsersBySpecificId = Mutable.empty();
        try {
            domainUsersBySpecificId.set((isUserFull ? driver.listUserFulls(specificIds) : driver.listUsers(specificIds)).stream().map(u -> {
                if (StringUtil.isNotDefined((String)u.getSpecificId())) {
                    return null;
                }
                u.setDomainId(identifier);
                return u;
            }).filter(Objects::nonNull).collect(Collectors.toMap(UserDetail::getSpecificId, u -> u)));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            domainUsersBySpecificId.set(Collections.emptyMap());
        }
        return silverpeasUsers.stream().map(u -> (UserDetail)((Map)domainUsersBySpecificId.get()).get(u.getSpecificId())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public UserFull getUserFull(String specificId) throws AdminException {
        return (UserFull)JdbcSqlQuery.unique(this.listUserFulls(Collections.singleton(specificId)));
    }

    @Override
    public List<UserFull> listUserFulls(Collection<String> specificIds) throws AdminException {
        return this.loadUserEntities(specificIds, UserFull.class);
    }

    @Override
    public String[] getUserMemberGroupIds(String specificId) throws AdminException {
        return ArrayUtil.emptyStringArray();
    }

    @Override
    public UserDetail[] getAllUsers() throws AdminException {
        return new UserDetail[0];
    }

    @Override
    public UserDetail[] getUsersBySpecificProperty(String propertyName, String value) throws AdminException {
        return new UserDetail[0];
    }

    @Override
    public UserDetail[] getUsersByQuery(Map<String, String> query) throws AdminException {
        return new UserDetail[0];
    }

    @Override
    public GroupDetail importGroup(String groupName) throws AdminException {
        return null;
    }

    @Override
    public void removeGroup(String groupId) throws AdminException {
    }

    @Override
    public GroupDetail synchroGroup(String groupId) throws AdminException {
        return null;
    }

    public UserDetail[] getAllUsers(String domainId) throws AdminException {
        UserDetail[] uds;
        try {
            DomainDriver domainDriver = this.getDomainDriver(domainId);
            uds = domainDriver.getAllUsers();
        }
        catch (AdminException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users in domain", (Object)domainId), (Throwable)((Object)e));
        }
        return uds;
    }

    public void indexAllUsers(String domainId) throws AdminException {
        String[] userIds;
        for (String userId : userIds = this.getUserIdsOfDomain(domainId)) {
            this.indexUser(userId);
        }
    }

    public void indexUser(String userId) {
        this.getUserIndexation().indexUser(userId);
    }

    public void unindexUser(String userId) {
        this.getUserIndexation().unindexUser(userId);
    }

    @Override
    public String createGroup(GroupDetail group) throws AdminException {
        GroupDetail specificGroup = new GroupDetail(group);
        try {
            this.setGroupSpecificId(group, specificGroup);
            specificGroup.setUserIds(this.translateUserIdsToSpecificIds(group.getDomainId(), group.getUserIds()));
            DomainDriver domainDriver = this.getDomainDriver(group.getDomainId());
            return domainDriver.createGroup(specificGroup);
        }
        catch (AdminException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)GROUP, (Object)group.getName()), (Throwable)((Object)e));
        }
    }

    private void setGroupSpecificId(GroupDetail group, GroupDetail specificGroup) throws AdminException {
        if (StringUtil.isDefined((String)group.getSuperGroupId())) {
            try (Connection connection = DBUtil.openConnection();){
                GroupDetail gr = this.groupDAO.getGroup(connection, group.getSuperGroupId());
                if (gr == null) {
                    throw new AdminException(SilverpeasExceptionMessages.unknown((String)"parent group", (Object)group.getSuperGroupId()), new String[0]);
                }
                specificGroup.setSuperGroupId(gr.getSpecificId());
            }
            catch (SQLException e) {
                throw new AdminException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void deleteGroup(String groupId) throws AdminException {
        try (Connection connection = DBUtil.openConnection();){
            GroupDetail gr = this.groupDAO.getGroup(connection, groupId);
            if (gr == null) {
                throw new AdminException(SilverpeasExceptionMessages.unknown((String)GROUP, (Object)groupId), new String[0]);
            }
            DomainDriver domainDriver = this.getDomainDriver(gr.getDomainId());
            domainDriver.deleteGroup(gr.getSpecificId());
            this.unindexGroup(groupId);
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)GROUP, (Object)groupId), e);
        }
    }

    @Override
    public void updateGroup(GroupDetail group) throws AdminException {
        GroupDetail specificGroup = new GroupDetail(group);
        try (Connection connection = DBUtil.openConnection();){
            this.setGroupSpecificId(group, specificGroup);
            specificGroup.setUserIds(this.translateUserIdsToSpecificIds(group.getDomainId(), group.getUserIds()));
            GroupDetail gr = this.groupDAO.getGroup(connection, group.getId());
            if (gr == null) {
                throw new AdminException(SilverpeasExceptionMessages.unknown((String)GROUP, (Object)group.getId()), new String[0]);
            }
            DomainDriver domainDriver = this.getDomainDriver(gr.getDomainId());
            specificGroup.setId(gr.getSpecificId());
            domainDriver.updateGroup(specificGroup);
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)GROUP, (Object)group.getId()), e);
        }
    }

    @Override
    public GroupDetail getGroup(String specificId) throws AdminException {
        GroupDetail group;
        try (Connection connection = DBUtil.openConnection();){
            GroupDetail gr = this.groupDAO.getGroup(connection, specificId);
            if (gr == null) {
                throw new AdminException(SilverpeasExceptionMessages.unknown((String)GROUP, (Object)specificId), new String[0]);
            }
            DomainDriver domainDriver = this.getDomainDriver(gr.getDomainId());
            group = domainDriver.getGroup(gr.getSpecificId());
            group.setId(specificId);
            group.setSpecificId(gr.getSpecificId());
            group.setDomainId(gr.getDomainId());
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)GROUP, (Object)specificId), e);
        }
        return group;
    }

    @Override
    public GroupDetail getGroupByName(String groupName) throws AdminException {
        return null;
    }

    public GroupDetail getGroupByNameInDomain(String groupName, String domainId) throws AdminException {
        try {
            DomainDriver domainDriver = this.getDomainDriver(domainId);
            return domainDriver.getGroupByName(groupName);
        }
        catch (AdminException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)GROUP, (Object)groupName), (Throwable)((Object)e));
        }
    }

    @Override
    public GroupDetail[] getGroups(String groupId) throws AdminException {
        GroupDetail[] groups;
        try (Connection connection = DBUtil.openConnection();){
            GroupDetail gr = this.groupDAO.getGroup(connection, groupId);
            if (gr == null) {
                throw new AdminException(SilverpeasExceptionMessages.unknown((String)GROUP, (Object)groupId), new String[0]);
            }
            DomainDriver domainDriver = this.getDomainDriver(gr.getDomainId());
            groups = domainDriver.getGroups(gr.getSpecificId());
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)GROUP, (Object)groupId), e);
        }
        return groups;
    }

    @Override
    public GroupDetail[] getAllGroups() throws AdminException {
        return new GroupDetail[0];
    }

    @Override
    public GroupDetail[] getAllRootGroups() throws AdminException {
        return new GroupDetail[0];
    }

    @Override
    public String[] getGroupMemberGroupIds(String groupId) throws AdminException {
        return ArrayUtil.emptyStringArray();
    }

    public String[] getGroupMemberGroupIds(String domainId, String groupId) throws AdminException {
        String[] groups;
        try {
            DomainDriver domainDriver = this.getDomainDriver(domainId);
            groups = domainDriver.getGroupMemberGroupIds(groupId);
        }
        catch (AdminException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"subgroups of group", (Object)groupId), (Throwable)((Object)e));
        }
        return groups;
    }

    public GroupDetail[] getAllRootGroups(String domainId) throws AdminException {
        GroupDetail[] groups;
        try {
            DomainDriver domainDriver = this.getDomainDriver(domainId);
            groups = domainDriver.getAllRootGroups();
        }
        catch (AdminException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"root groups in domain", (Object)domainId), (Throwable)((Object)e));
        }
        return groups;
    }

    public List<GroupDetail> getAllGroupOfDomain(String domainId) throws AdminException {
        List<GroupDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.groupDAO.getAllGroupsByDomainId(connection, domainId, false);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all groups in domain", (Object)domainId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public void indexAllGroups(String domainId) throws AdminException {
        List<GroupDetail> groups = this.getAllGroupOfDomain(domainId);
        for (GroupDetail group : groups) {
            this.indexGroup(group);
        }
    }

    public void indexGroup(GroupDetail group) {
        FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey("groups", "GroupRow", group.getId()));
        indexEntry.setLastModificationDate(new Date());
        indexEntry.setTitle(group.getName());
        indexEntry.setPreview(group.getDescription());
        indexEntry.addField("DomainId", group.getDomainId());
        indexEntry.addField("SpecificId", group.getSpecificId());
        indexEntry.addField("SuperGroupId", group.getSuperGroupId());
        indexEntry.addField("SynchroRule", group.getRule());
        IndexEngineProxy.addIndexEntry(indexEntry);
    }

    public void unindexGroup(String groupId) {
        FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey("groups", "GroupRow", groupId));
        IndexEngineProxy.removeIndexEntry(indexEntry.getPK());
    }

    public Map<String, String> authenticate(String sKey) throws AdminException {
        return this.authenticate(sKey, true);
    }

    public Map<String, String> authenticate(String sKey, boolean removeKey) throws AdminException {
        HashMap<String, String> loginDomainId = new HashMap<String, String>();
        try {
            KeyStoreRow ksr = this.getOrganizationSchema().keyStore().getRecordByKey(DomainDriverManager.idAsInt(sKey));
            if (ksr == null) {
                throw new AdminException(SilverpeasExceptionMessages.unknown((String)"authentication key", (Object)sKey), new String[0]);
            }
            loginDomainId.put("login", ksr.login);
            loginDomainId.put("domainId", DomainDriverManager.idAsString(ksr.domainId));
            if (removeKey) {
                this.getOrganizationSchema().keyStore().removeKeyStoreRecord(DomainDriverManager.idAsInt(sKey));
            }
            return loginDomainId;
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnValidating((String)"authentication key", (Object)sKey), e);
        }
    }

    public Domain[] getAllDomains() throws AdminException {
        Domain[] domains;
        try {
            DomainRow[] drs = this.getOrganizationSchema().domain().getAllDomains();
            if (drs == null || drs.length == 0) {
                throw new AdminException("No domains found", new String[0]);
            }
            domains = new Domain[drs.length];
            for (int i = 0; i < drs.length; ++i) {
                domains[i] = new Domain();
                domains[i].setId(Integer.toString(drs[i].id));
                domains[i].setName(drs[i].name);
                domains[i].setDescription(drs[i].description);
                domains[i].setDriverClassName(drs[i].className);
                domains[i].setPropFileName(drs[i].propFileName);
                domains[i].setAuthenticationServer(drs[i].authenticationServer);
            }
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all domains", (Object)""), e);
        }
        return domains;
    }

    public long getDomainActions(String domainId) throws AdminException {
        return this.getDomainDriver(domainId).getDriverActions();
    }

    public String getNextDomainId() {
        return DomainDriverManager.idAsString(this.getOrganizationSchema().domain().getNextId());
    }

    public String createDomain(Domain theDomain) throws AdminException {
        try {
            DomainRow dr = this.toDomainRow(theDomain);
            this.getOrganizationSchema().domain().createDomain(dr);
            return DomainDriverManager.idAsString(dr.id);
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)DOMAIN, (Object)theDomain.getName()), e);
        }
    }

    public String updateDomain(Domain theDomain) throws AdminException {
        try {
            DomainRow dr = this.toDomainRow(theDomain);
            this.getOrganizationSchema().domain().updateDomain(dr);
            if (this.domainDriverInstances.get(theDomain.getId()) != null) {
                this.domainDriverInstances.remove(theDomain.getId());
            }
            return theDomain.getId();
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)DOMAIN, (Object)theDomain.getName()), e);
        }
    }

    private DomainRow toDomainRow(Domain domain) {
        DomainRow row = new DomainRow();
        row.id = DomainDriverManager.idAsInt(domain.getId());
        row.name = domain.getName();
        row.description = domain.getDescription();
        row.className = domain.getDriverClassName();
        row.propFileName = domain.getPropFileName();
        row.authenticationServer = domain.getAuthenticationServer();
        row.theTimeStamp = "0";
        row.silverpeasServerURL = domain.getSilverpeasServerURL();
        return row;
    }

    public void removeDomain(String domainId) throws AdminException {
        try {
            this.getOrganizationSchema().domain().removeDomain(DomainDriverManager.idAsInt(domainId));
            if (this.domainDriverInstances.get(domainId) != null) {
                this.domainDriverInstances.remove(domainId);
            }
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)DOMAIN, (Object)domainId), e);
        }
    }

    public Domain getDomain(String domainId) throws AdminException {
        Domain domains;
        try {
            DomainRow dr = this.getOrganizationSchema().domain().getDomain(DomainDriverManager.idAsInt(domainId));
            if (dr == null) {
                throw new AdminNotFoundException(SilverpeasExceptionMessages.unknown((String)DOMAIN, (Object)domainId), new String[0]);
            }
            domains = new Domain();
            domains.setId(Integer.toString(dr.id));
            domains.setName(dr.name);
            domains.setDescription(dr.description);
            domains.setDriverClassName(dr.className);
            domains.setPropFileName(dr.propFileName);
            domains.setAuthenticationServer(dr.authenticationServer);
            domains.setSilverpeasServerURL(dr.silverpeasServerURL);
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)DOMAIN, (Object)domainId), e);
        }
        return domains;
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={AdminException.class})
    public DomainDriver getDomainDriver(String domainId) throws AdminException {
        DomainDriver domainDriver;
        try {
            domainDriver = this.domainDriverInstances.get(domainId);
            if (domainDriver == null) {
                DomainRow dr = this.getOrganizationSchema().domain().getDomain(DomainDriverManager.idAsInt(domainId));
                if (dr == null) {
                    throw new AdminException(SilverpeasExceptionMessages.unknown((String)"driver for domain", (Object)domainId), new String[0]);
                }
                domainDriver = this.getDomainDriver(domainId, dr);
                this.domainDriverInstances.put(domainId, domainDriver);
            }
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"driver of domain", (Object)domainId), e);
        }
        return domainDriver;
    }

    private DomainDriver getDomainDriver(String domainId, DomainRow dr) throws AdminException {
        DomainDriver domainDriver;
        try {
            domainDriver = DomainDriverProvider.getDriver(dr.className);
            domainDriver.init(DomainDriverManager.idAsInt(domainId), dr.propFileName, dr.authenticationServer);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"driver of domain", (Object)domainId), e);
        }
        return domainDriver;
    }

    public void beginSynchronization(String domainId) throws AdminException {
        DomainDriver domainDriver = this.getDomainDriver(domainId);
        domainDriver.beginSynchronization();
    }

    public String endSynchronization(String domainId, boolean cancelSynchro) throws AdminException {
        DomainDriver domainDriver = this.getDomainDriver(domainId);
        return domainDriver.endSynchronization(cancelSynchro);
    }

    private String[] translateUserIdsToSpecificIds(String domainId, String[] ids) throws AdminException {
        String[] stringArray;
        block9: {
            if (ids == null || ids.length == 0) {
                return ArrayUtil.emptyStringArray();
            }
            Connection connection = DBUtil.openConnection();
            try {
                ListSlice<UserDetail> users = this.userDAO.getUsersByCriteria(connection, new UserDetailsSearchCriteria().onDomainIds(domainId).onUserIds(ids));
                stringArray = (String[])users.stream().map(UserDetail::getSpecificId).toArray(String[]::new);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)USERS, (Object)String.join((CharSequence)",", ids)), e);
                }
            }
            connection.close();
        }
        return stringArray;
    }

    @Override
    public List<String> getUserAttributes() throws AdminException {
        return Collections.emptyList();
    }

    private OrganizationSchema getOrganizationSchema() {
        return this.organizationSchema;
    }

    private UserIndexation getUserIndexation() {
        return (UserIndexation)ServiceProvider.getService(UserIndexation.class, (Annotation[])new Annotation[0]);
    }

    @Override
    public void resetPassword(UserDetail user, String password) throws AdminException {
        try {
            DomainDriver domainDriver = this.getDomainDriver(user.getDomainId());
            domainDriver.resetPassword(user, password);
        }
        catch (AdminException e) {
            throw new AdminException("Fail to reset password for user " + user.getId(), (Throwable)((Object)e));
        }
    }

    @Override
    public void resetEncryptedPassword(UserDetail user, String encryptedPassword) throws AdminException {
        try {
            DomainDriver domainDriver = this.getDomainDriver(user.getDomainId());
            domainDriver.resetEncryptedPassword(user, encryptedPassword);
        }
        catch (AdminException e) {
            throw new AdminException("Fail to reset encrypted password for user " + user.getId(), (Throwable)((Object)e));
        }
    }
}

