/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.service;

import java.util.Optional;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasPersonalComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasSharedComponentInstance;
import org.silverpeas.core.admin.component.service.SilverpeasComponentInstanceProvider;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.kernel.util.StringUtil;

@Provider
public class DefaultSilverpeasComponentInstanceProvider
implements SilverpeasComponentInstanceProvider {
    public Optional<SilverpeasComponentInstance> getById(String componentInstanceId) {
        return OrganizationController.get().getComponentInstance(componentInstanceId);
    }

    public Optional<SilverpeasSharedComponentInstance> getSharedById(String sharedComponentInstanceId) {
        SilverpeasComponentInstance instance = this.getById(sharedComponentInstanceId).orElse(null);
        if (instance instanceof SilverpeasSharedComponentInstance) {
            return Optional.of((SilverpeasSharedComponentInstance)instance);
        }
        return Optional.empty();
    }

    public Optional<SilverpeasPersonalComponentInstance> getPersonalById(String personalComponentInstanceId) {
        return Optional.ofNullable(PersonalComponentInstance.from(personalComponentInstanceId).orElse(null));
    }

    public String getComponentName(String componentInstanceId) {
        String componentName = ComponentInst.getComponentName(componentInstanceId);
        if (StringUtil.isNotDefined((String)componentName)) {
            componentName = PersonalComponentInstance.getComponentName(componentInstanceId);
        }
        return componentName;
    }
}

