/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.process.check;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.silverpeas.core.admin.component.exception.ComponentFileFilterException;
import org.silverpeas.core.admin.component.model.ComponentFileFilterParameter;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.core.notification.message.MessageNotifier;
import org.silverpeas.core.process.io.IOAccess;
import org.silverpeas.core.process.io.file.DummyHandledFile;
import org.silverpeas.core.process.io.file.FileHandler;
import org.silverpeas.core.process.management.AbstractFileProcessCheck;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.util.error.SilverpeasTransverseErrorUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Service
public class ComponentFileFilterProcessCheck
extends AbstractFileProcessCheck {
    @Inject
    private OrganizationController organizationController;

    @Override
    public void checkFiles(ProcessExecutionContext processExecutionContext, FileHandler fileHandler) {
        if (IOAccess.READ_WRITE.equals((Object)fileHandler.getIoAccess())) {
            Set<String> componentInstanceIds = this.identifyComponentInstances(processExecutionContext, fileHandler);
            for (String componentInstanceId : componentInstanceIds) {
                SilverpeasComponentInstance component = this.organizationController.getComponentInstance(componentInstanceId).orElseThrow(() -> new SilverpeasRuntimeException("No component instance found with id " + componentInstanceId));
                ComponentFileFilterParameter componentFileFilter = ComponentFileFilterParameter.from(component);
                Collection<File> filesInSession = fileHandler.listAllSessionHandledRootPathFiles();
                this.checkFilesInSession(component, componentFileFilter, filesInSession);
                Set<DummyHandledFile> dummyFiles = fileHandler.getDummyHandledFiles(componentInstanceId);
                this.checkDummyHandledFiles(componentFileFilter, dummyFiles);
            }
        }
    }

    private void checkDummyHandledFiles(ComponentFileFilterParameter componentFileFilter, Collection<DummyHandledFile> dummyFiles) {
        for (DummyHandledFile dummyHandledFile : dummyFiles) {
            if (dummyHandledFile.isDeleted() || componentFileFilter.isMimeTypeAuthorized(dummyHandledFile.getMimeType())) continue;
            ComponentFileFilterException exception = new ComponentFileFilterException(componentFileFilter, dummyHandledFile.getName());
            MessageNotifier.addSevere((String)SilverpeasTransverseErrorUtil.performExceptionMessage(exception, MessageManager.getLanguage()), (Object[])new Object[0]);
            throw exception;
        }
    }

    private void checkFilesInSession(SilverpeasComponentInstance component, ComponentFileFilterParameter componentFileFilter, Collection<File> filesInSession) {
        for (File sessionDirectory : filesInSession) {
            for (File sessionFile : FileUtils.listFiles((File)sessionDirectory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
                if (!sessionFile.getPath().contains(component.getId())) continue;
                componentFileFilter.verifyFileAuthorized(sessionFile);
            }
        }
    }
}

