/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.silverpeas.core.admin.component.model.MultilangHashMapAdapter;
import org.silverpeas.core.admin.component.model.Option;
import org.silverpeas.core.admin.component.model.ParameterInputType;
import org.silverpeas.core.admin.component.model.ParameterUpdatableType;
import org.silverpeas.core.admin.component.model.Warning;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.logging.SilverLogger;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ParameterType", propOrder={"name", "label", "order", "mandatory", "value", "options", "type", "size", "updatable", "help", "warning", "personalSpaceValue"})
public class Parameter {
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected Map<String, String> label;
    protected int order;
    protected boolean mandatory;
    @XmlElement(required=true)
    protected String value;
    @XmlElementWrapper(name="options")
    @XmlElement(name="option")
    protected List<Option> options;
    @XmlElement(required=true)
    protected String type;
    protected Integer size;
    @XmlElement(required=true)
    protected String updatable;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=MultilangHashMapAdapter.class)
    protected Map<String, String> help;
    protected Warning warning;
    protected String personalSpaceValue;

    public Parameter() {
    }

    public Parameter(Parameter param) {
        this.name = param.name;
        this.order = param.order;
        this.mandatory = param.mandatory;
        this.value = param.value;
        this.type = param.type;
        this.size = param.size;
        this.updatable = param.updatable;
        this.personalSpaceValue = param.personalSpaceValue;
        this.setHelp(new HashMap<String, String>(param.getHelp()));
        this.warning = Optional.ofNullable(param.warning).map(Warning::new).orElse(null);
        this.setLabel(new HashMap<String, String>(param.getLabel()));
        this.options = Optional.ofNullable(param.options).stream().flatMap(Collection::stream).map(Option::new).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    protected Map<String, String> getLabel() {
        if (this.label == null) {
            this.label = new HashMap<String, String>();
        }
        return this.label;
    }

    public void putLabel(String language, String label) {
        this.getLabel().put(I18NHelper.checkLanguage(language), label);
    }

    private void setLabel(Map<String, String> value) {
        this.label = value;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int value) {
        this.order = value;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean value) {
        this.mandatory = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<Option> getOptions() {
        if (this.isXmlTemplate() && CollectionUtil.isEmpty(this.options)) {
            this.loadXmlTemplates();
        } else if (this.options == null) {
            this.options = new ArrayList<Option>();
        }
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer value) {
        this.size = value;
    }

    public String getUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(String value) {
        this.updatable = value;
    }

    protected Map<String, String> getHelp() {
        if (this.help == null) {
            this.help = new HashMap<String, String>();
        }
        return this.help;
    }

    public void putHelp(String language, String help) {
        this.getHelp().put(I18NHelper.checkLanguage(language), help);
    }

    private void setHelp(Map<String, String> value) {
        this.help = value;
    }

    public Optional<Warning> getWarning() {
        return Optional.ofNullable(this.warning);
    }

    public void setWarning(Warning warning) {
        this.warning = warning;
    }

    public String getPersonalSpaceValue() {
        return this.personalSpaceValue;
    }

    public void setPersonalSpaceValue(String value) {
        this.personalSpaceValue = value;
    }

    public boolean isVisible() {
        return !this.isNeverUpdatable() && !this.isHidden();
    }

    public boolean isHidden() {
        return ParameterUpdatableType.hidden == ParameterUpdatableType.valueOf(this.getUpdatable());
    }

    public boolean isUpdatableOnCreationOnly() {
        return ParameterUpdatableType.creation == ParameterUpdatableType.valueOf(this.getUpdatable());
    }

    public boolean isAlwaysUpdatable() {
        return ParameterUpdatableType.always == ParameterUpdatableType.valueOf(this.getUpdatable());
    }

    public boolean isNeverUpdatable() {
        return ParameterUpdatableType.never == ParameterUpdatableType.valueOf(this.getUpdatable());
    }

    public boolean isText() {
        return ParameterInputType.text == ParameterInputType.valueOf(this.getType());
    }

    public boolean isCheckbox() {
        return ParameterInputType.checkbox == ParameterInputType.valueOf(this.getType());
    }

    public boolean isRadio() {
        return ParameterInputType.radio == ParameterInputType.valueOf(this.getType());
    }

    public boolean isSelect() {
        return ParameterInputType.select == ParameterInputType.valueOf(this.getType());
    }

    public boolean isXmlTemplate() {
        return ParameterInputType.xmltemplates == ParameterInputType.valueOf(this.getType());
    }

    private void loadXmlTemplates() {
        this.options = new ArrayList<Option>();
        try {
            List<PublicationTemplate> templates = PublicationTemplateManager.getInstance().getPublicationTemplates(true);
            for (PublicationTemplate template : templates) {
                Option option = new Option();
                for (String lang : DisplayI18NHelper.getLanguages()) {
                    option.getName().put(lang, template.getName());
                }
                option.setValue(template.getFileName());
                this.options.add(option);
            }
        }
        catch (PublicationTemplateException ex) {
            SilverLogger.getLogger((Object)this).error("Error in loading XML templates. Parameter: " + this.name, (Throwable)((Object)ex));
        }
    }
}

