/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.admin.component.model.ComponentLocalization;
import org.silverpeas.core.admin.component.model.LocalizedGroupOfParameters;
import org.silverpeas.core.admin.component.model.LocalizedOption;
import org.silverpeas.core.admin.component.model.LocalizedWarning;
import org.silverpeas.core.admin.component.model.Option;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;
import org.silverpeas.core.admin.component.model.Warning;

public class LocalizedParameter
extends ComponentLocalization {
    private final Parameter realParameter;
    private final String localizedGroupPrefixKey;
    private List<LocalizedOption> localizedOptions;
    private LocalizedWarning localizedWarning;

    public LocalizedParameter(LocalizedGroupOfParameters bundle, Parameter parameter) {
        super(bundle);
        this.realParameter = parameter;
        this.localizedGroupPrefixKey = bundle.getBundleKeyPrefix() + ".";
    }

    public LocalizedParameter(SilverpeasComponent component, Parameter parameter, String lang) {
        super(component, lang);
        this.realParameter = parameter;
        this.localizedGroupPrefixKey = "";
    }

    public static LocalizedParameter toLocalizedParameter(SilverpeasComponent component, Parameter parameter, String lang) {
        return new LocalizedParameter(component, parameter, lang);
    }

    protected String getBundleKeyPrefix() {
        return this.localizedGroupPrefixKey + "parameter." + this.getName();
    }

    public String getHelp() {
        return this.getLocalized(this.getBundleKeyPrefix() + ".help", this.realParameter.getHelp());
    }

    public Optional<LocalizedWarning> getWarning() {
        if (this.localizedWarning == null) {
            this.localizedWarning = this.realParameter.getWarning().map(w -> new LocalizedWarning(this, (Warning)w)).orElse(null);
        }
        return Optional.ofNullable(this.localizedWarning);
    }

    public String getLabel() {
        return this.getLocalized(this.getBundleKeyPrefix() + ".label", this.realParameter.getLabel());
    }

    public String getName() {
        return this.realParameter.getName();
    }

    public List<LocalizedOption> getOptions() {
        if (this.localizedOptions == null) {
            this.localizedOptions = new ArrayList<LocalizedOption>();
            for (Option option : this.realParameter.getOptions()) {
                this.localizedOptions.add(new LocalizedOption(this, option));
            }
        }
        return this.localizedOptions;
    }

    public void setOptions(List<LocalizedOption> options) {
        this.localizedOptions = options;
    }

    public int getOrder() {
        return this.realParameter.getOrder();
    }

    public String getPersonalSpaceValue() {
        return this.realParameter.getPersonalSpaceValue();
    }

    public Integer getSize() {
        return this.realParameter.getSize();
    }

    public String getType() {
        return this.realParameter.getType();
    }

    public String getUpdatable() {
        return this.realParameter.getUpdatable();
    }

    public String getValue() {
        return this.realParameter.getValue();
    }

    public boolean isAlwaysUpdatable() {
        return this.realParameter.isAlwaysUpdatable();
    }

    public boolean isCheckbox() {
        return this.realParameter.isCheckbox();
    }

    public boolean isHidden() {
        return this.realParameter.isHidden();
    }

    public boolean isMandatory() {
        return this.realParameter.isMandatory();
    }

    public boolean isNeverUpdatable() {
        return this.realParameter.isNeverUpdatable();
    }

    public boolean isRadio() {
        return this.realParameter.isRadio();
    }

    public boolean isSelect() {
        return this.realParameter.isSelect();
    }

    public boolean isText() {
        return this.realParameter.isText();
    }

    public boolean isUpdatableOnCreationOnly() {
        return this.realParameter.isUpdatableOnCreationOnly();
    }

    public boolean isVisible() {
        return this.realParameter.isVisible();
    }

    public boolean isXmlTemplate() {
        return this.realParameter.isXmlTemplate();
    }
}

