/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.silverpeas.core.admin.component.constant.ComponentInstanceParameterName;
import org.silverpeas.core.admin.component.exception.ComponentFileFilterException;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.core.notification.message.MessageNotifier;
import org.silverpeas.core.util.error.SilverpeasTransverseErrorUtil;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.util.StringUtil;

public class ComponentFileFilterParameter {
    static String defaultAuthorizedFiles = ComponentInstanceParameterName.authorizedFileExtension.getDefaultValue();
    static String defaultForbiddenFiles = ComponentInstanceParameterName.forbiddenFileExtension.getDefaultValue();
    private final SilverpeasComponentInstance component;
    private boolean isAuthorization = true;
    private String fileFilters = null;
    private boolean isFileFilterGloballySet = false;
    private Collection<String> mimeTypes = null;

    private ComponentFileFilterParameter(SilverpeasComponentInstance component) {
        this.component = component;
    }

    public static ComponentFileFilterParameter from(SilverpeasComponentInstance component) {
        return new ComponentFileFilterParameter(component).initialize();
    }

    private Collection<String> getMimeTypes() {
        return this.mimeTypes;
    }

    private ComponentFileFilterParameter initialize() {
        if (this.mimeTypes == null) {
            this.mimeTypes = new HashSet<String>();
            this.fileFilters = this.component.getParameterValue(ComponentInstanceParameterName.authorizedFileExtension.name());
            if (StringUtil.isDefined((String)this.fileFilters)) {
                this.parseFileFilters(this.fileFilters);
                return this;
            }
            this.fileFilters = this.component.getParameterValue(ComponentInstanceParameterName.forbiddenFileExtension.name());
            if (StringUtil.isDefined((String)this.fileFilters)) {
                this.isAuthorization = false;
                this.parseFileFilters(this.fileFilters);
                return this;
            }
            this.isFileFilterGloballySet = true;
            this.fileFilters = defaultAuthorizedFiles;
            if (StringUtil.isDefined((String)this.fileFilters)) {
                this.parseFileFilters(this.fileFilters);
                return this;
            }
            this.fileFilters = defaultForbiddenFiles;
            if (StringUtil.isDefined((String)this.fileFilters)) {
                this.isAuthorization = false;
                this.parseFileFilters(this.fileFilters);
            }
        }
        return this;
    }

    private void parseFileFilters(String definedFileFilters) {
        this.fileFilters = "";
        if (StringUtil.isDefined((String)definedFileFilters)) {
            this.fileFilters = definedFileFilters.trim().replaceAll("[* ;,]+[.]", ",").replaceAll("[, ]+", ", ").replaceAll("^, ", "");
            for (String fileFilter : this.fileFilters.split(",")) {
                this.mimeTypes.add(FileUtil.getMimeType("file." + fileFilter.trim()));
            }
        }
    }

    public SilverpeasComponentInstance getComponent() {
        return this.component;
    }

    public boolean isAuthorization() {
        return this.isAuthorization;
    }

    public String getFileFilters() {
        return this.fileFilters;
    }

    public boolean isFileFilterGloballySet() {
        return this.isFileFilterGloballySet;
    }

    public boolean isFileAuthorized(File file) {
        return file != null && this.isMimeTypeAuthorized(FileUtil.getMimeType(file.getPath()));
    }

    public void verifyFileAuthorized(File file) {
        if (!this.isFileAuthorized(file)) {
            ComponentFileFilterException exception = new ComponentFileFilterException(this, file != null ? file.getName() : "");
            MessageNotifier.addSevere((String)SilverpeasTransverseErrorUtil.performExceptionMessage(exception, MessageManager.getLanguage()), (Object[])new Object[0]);
            throw exception;
        }
    }

    public boolean isMimeTypeAuthorized(String mimeType) {
        if (!this.getMimeTypes().isEmpty()) {
            if (DocumentType.decode(mimeType) != null) {
                return true;
            }
            if (!StringUtil.isDefined((String)mimeType)) {
                return false;
            }
            return this.isAuthorization() == this.getMimeTypes().contains(mimeType);
        }
        return true;
    }
}

