/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.admin.component.model.ObjectFactory;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.SystemWrapper;

@Service
@Singleton
public class WAComponentRegistry
implements Initialization {
    private final Map<String, WAComponent> componentsByName = new HashMap<String, WAComponent>();

    public static WAComponentRegistry get() {
        return (WAComponentRegistry)ServiceProvider.getService(WAComponentRegistry.class, (Annotation[])new Annotation[0]);
    }

    WAComponentRegistry() {
    }

    public void init() {
        Path descriptorHome = WAComponentRegistry.getWAComponentDescriptorHome();
        try (Stream<Path> paths = Files.find(descriptorHome, 2, (p, a2) -> p.toFile().isFile() && "xml".equalsIgnoreCase(FilenameUtils.getExtension((String)p.toString())) && !p.getParent().toString().endsWith("personals"), new FileVisitOption[0]);){
            paths.forEach(p -> {
                WAComponent component = WAComponentRegistry.loadComponent(p.toFile());
                this.componentsByName.put(component.getName(), component);
            });
        }
        catch (IOException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    public int getPriority() {
        return 0;
    }

    public Optional<WAComponent> getWAComponent(String componentName) {
        return Optional.ofNullable(this.componentsByName.get(componentName));
    }

    public Map<String, WAComponent> getAllWAComponents() {
        return Collections.unmodifiableMap(this.componentsByName);
    }

    public void putWorkflow(WAComponent waComponent) {
        try {
            Path descriptor = Paths.get(WAComponentRegistry.getWAComponentDescriptorHome().toString(), "workflows", waComponent.getName() + ".xml");
            WAComponentRegistry.storeComponent(waComponent, descriptor.toFile());
            this.componentsByName.put(waComponent.getName(), waComponent);
        }
        catch (JAXBException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void putWorkflow(File xmlComponent) {
        WAComponent waComponent = WAComponentRegistry.loadComponent(xmlComponent);
        this.putWorkflow(waComponent);
    }

    public void removeWorkflow(WAComponent waComponent) {
        try {
            if (this.componentsByName.containsKey(waComponent.getName())) {
                Path descriptor = Paths.get(WAComponentRegistry.getWAComponentDescriptorHome().toString(), "workflows", waComponent.getName() + ".xml");
                FileUtil.forceDeletion(descriptor.toFile());
                this.componentsByName.remove(waComponent.getName());
            }
        }
        catch (IOException e) {
            throw new SilverpeasRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static Path getWAComponentDescriptorHome() {
        SystemWrapper system = SystemWrapper.getInstance();
        return Paths.get(system.getenv("SILVERPEAS_HOME"), "xmlcomponents");
    }

    private static WAComponent loadComponent(File descriptor) {
        WAComponent wAComponent;
        JAXBContext context = JAXBContext.newInstance((String)"org.silverpeas.core.admin.component.model");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        FileInputStream in = new FileInputStream(descriptor);
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            wAComponent = (WAComponent)unmarshaller.unmarshal(factory.createXMLStreamReader(in), WAComponent.class).getValue();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException | XMLStreamException e) {
                throw new SilverpeasRuntimeException(e.getMessage(), e);
            }
        }
        ((InputStream)in).close();
        return wAComponent;
    }

    private static void storeComponent(WAComponent component, File descriptor) throws JAXBException {
        if (descriptor.exists()) {
            Path descriptorCopy = Paths.get(descriptor.getParent(), FilenameUtils.getBaseName((String)descriptor.getName()).concat(".").concat(LocalDateTime.now().toString().replaceAll("\\D", "")));
            try {
                Files.move(descriptor.toPath(), descriptorCopy, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }
        JAXBContext context = JAXBContext.newInstance((String)"org.silverpeas.core.admin.component.model");
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.schemaLocation", (Object)"http://silverpeas.org/xml/ns/component http://www.silverpeas.org/xsd/component.xsd");
        ObjectFactory objectFactory = new ObjectFactory();
        marshaller.marshal(objectFactory.createWAComponent(component), descriptor);
    }
}

