/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.tagcloud.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.tagcloud.dao.TagCloudPK;
import org.silverpeas.core.tagcloud.model.TagCloud;
import org.silverpeas.kernel.logging.SilverLogger;

public class TagCloudDAO {
    private static final int INITIAL_CAPACITY = 100;
    private static final String TABLE_NAME = "SB_TagCloud_TagCloud";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_TAG = "tag";
    private static final String COLUMN_LABEL = "label";
    private static final String COLUMN_INSTANCEID = "instanceId";
    private static final String COLUMN_EXTERNALID = "externalId";
    private static final String COLUMN_EXTERNALTYPE = "externalType";
    private static final String ALL_COLUMNS = "id, tag, label, instanceId, externalId, externalType";
    private static final String DELETE_ALL = "DELETE FROM SB_TagCloud_TagCloud WHERE instanceId = ? ";

    private TagCloudDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTagCloud(Connection con, TagCloud tagCloud) throws SQLException {
        String query = "INSERT INTO SB_TagCloud_TagCloud VALUES (?, ?, ?, ?, ?, ?)";
        int newId = 0;
        try {
            newId = DBUtil.getNextId((String)TABLE_NAME, (String)COLUMN_ID);
        }
        catch (Exception e) {
            SilverLogger.getLogger(TagCloudDAO.class).error((Throwable)e);
        }
        PreparedStatement prepStmt = con.prepareStatement(query);
        int index = 1;
        try {
            prepStmt.setInt(index++, newId);
            prepStmt.setString(index++, tagCloud.getTag());
            prepStmt.setString(index++, tagCloud.getLabel());
            prepStmt.setString(index++, tagCloud.getInstanceId());
            prepStmt.setString(index++, tagCloud.getExternalId());
            prepStmt.setInt(index++, tagCloud.getExternalType());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTagCloud(Connection con, TagCloudPK pk, int type) throws SQLException {
        String query = new StringBuffer(100).append("DELETE FROM ").append(TABLE_NAME).append(" WHERE ").append(COLUMN_INSTANCEID).append(" = ?").append(" AND ").append(COLUMN_EXTERNALID).append(" = ?").append(" AND ").append(COLUMN_EXTERNALTYPE).append(" = ?").toString();
        PreparedStatement prepStmt = con.prepareStatement(query);
        try {
            int index = 1;
            prepStmt.setString(index++, pk.getInstanceId());
            prepStmt.setString(index++, pk.getId());
            prepStmt.setInt(index++, type);
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public static void deleteAllTagClouds(Connection con, String instanceId) throws SQLException {
        try (PreparedStatement deletion = con.prepareStatement(DELETE_ALL);){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
    }

    public static Collection<TagCloud> getInstanceTagClouds(Connection con, String instanceId) throws SQLException {
        String query = new StringBuffer(100).append("SELECT ").append(ALL_COLUMNS).append(" FROM ").append(TABLE_NAME).append(" WHERE ").append(COLUMN_INSTANCEID).append(" = ?").append(" ORDER BY ").append(COLUMN_TAG).append(" ASC").toString();
        ArrayList<TagCloud> tagClouds = new ArrayList<TagCloud>(100);
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, instanceId);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    tagClouds.add(TagCloudDAO.resultSet2TagCloud(rs));
                }
            }
        }
        return tagClouds;
    }

    public static Collection<TagCloud> getElementTagClouds(Connection con, TagCloudPK pk) throws SQLException {
        String query = new StringBuffer(100).append("SELECT ").append(ALL_COLUMNS).append(" FROM ").append(TABLE_NAME).append(" WHERE ").append(COLUMN_INSTANCEID).append(" = ?").append(" AND ").append(COLUMN_EXTERNALID).append(" = ?").append(" AND ").append(COLUMN_EXTERNALTYPE).append(" = ?").append(" ORDER BY ").append(COLUMN_TAG).append(" ASC").toString();
        ArrayList<TagCloud> tagClouds = new ArrayList<TagCloud>(100);
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, pk.getInstanceId());
            prepStmt.setString(2, pk.getId());
            prepStmt.setInt(3, pk.getType());
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    tagClouds.add(TagCloudDAO.resultSet2TagCloud(rs));
                }
            }
        }
        return tagClouds;
    }

    public static Collection<TagCloud> getTagCloudsByTags(Connection con, String tags, String instanceId, int type) throws SQLException {
        StringTokenizer st = new StringTokenizer(tags);
        int tagCount = st.countTokens();
        boolean isInstanceIdFilter = instanceId != null && instanceId.length() > 0;
        StringBuilder querySb = new StringBuilder(100).append("SELECT ").append(ALL_COLUMNS).append(" FROM ").append(TABLE_NAME).append(" WHERE (");
        for (int i = 0; i < tagCount; ++i) {
            if (i > 0) {
                querySb.append(" OR ");
            }
            querySb.append(COLUMN_TAG).append(" = ?");
        }
        querySb.append(") AND ").append(COLUMN_EXTERNALTYPE).append(" = ?");
        if (isInstanceIdFilter) {
            querySb.append(" AND ").append(COLUMN_INSTANCEID).append(" = ?");
        }
        querySb.append(" ORDER BY ").append(COLUMN_INSTANCEID).append(" ASC, ").append(COLUMN_EXTERNALID).append(" ASC");
        ArrayList<TagCloud> tagClouds = new ArrayList<TagCloud>(100);
        try (PreparedStatement prepStmt = con.prepareStatement(querySb.toString());){
            int index = 1;
            while (st.hasMoreTokens()) {
                prepStmt.setString(index++, st.nextToken());
            }
            prepStmt.setInt(index++, type);
            if (isInstanceIdFilter) {
                prepStmt.setString(index++, instanceId);
            }
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    tagClouds.add(TagCloudDAO.resultSet2TagCloud(rs));
                }
            }
        }
        return tagClouds;
    }

    public static Collection<TagCloud> getTagCloudsByElement(Connection con, String instanceId, String externalId, int type) throws SQLException {
        StringBuilder querySb = new StringBuilder(100).append("SELECT ").append(ALL_COLUMNS).append(" FROM ").append(TABLE_NAME).append(" WHERE ").append(COLUMN_INSTANCEID).append(" = ?").append(" AND ").append(COLUMN_EXTERNALID).append(" = ?").append(" AND ").append(COLUMN_EXTERNALTYPE).append(" = ?").append(" ORDER BY ").append(COLUMN_TAG).append(" ASC");
        ArrayList<TagCloud> tagClouds = new ArrayList<TagCloud>(100);
        try (PreparedStatement prepStmt = con.prepareStatement(querySb.toString());){
            prepStmt.setString(1, instanceId);
            prepStmt.setString(2, externalId);
            prepStmt.setInt(3, type);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    tagClouds.add(TagCloudDAO.resultSet2TagCloud(rs));
                }
            }
        }
        return tagClouds;
    }

    public static String getTagsByElement(Connection con, TagCloudPK pk) throws SQLException {
        StringBuilder querySb = new StringBuilder(100).append("SELECT ").append(COLUMN_TAG).append(" FROM ").append(TABLE_NAME).append(" WHERE ").append(COLUMN_INSTANCEID).append(" = ?").append(" AND ").append(COLUMN_EXTERNALID).append(" = ?").append(" AND ").append(COLUMN_EXTERNALTYPE).append(" = ?").append(" ORDER BY ").append(COLUMN_TAG).append(" ASC");
        StringBuilder tags = new StringBuilder();
        try (PreparedStatement prepStmt = con.prepareStatement(querySb.toString());){
            prepStmt.setString(1, pk.getInstanceId());
            prepStmt.setString(2, pk.getId());
            prepStmt.setInt(3, pk.getType());
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    if (tags.length() > 0) {
                        tags.append(" ");
                    }
                    tags.append(rs.getString(1));
                }
            }
        }
        return tags.toString();
    }

    private static TagCloud resultSet2TagCloud(ResultSet rs) throws SQLException {
        return new TagCloud(rs.getInt(COLUMN_ID), rs.getString(COLUMN_TAG), rs.getString(COLUMN_LABEL), rs.getString(COLUMN_INSTANCEID), rs.getString(COLUMN_EXTERNALID), rs.getInt(COLUMN_EXTERNALTYPE));
    }
}

