/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.core.silverstatistics.volume.model.StatDataType;
import org.silverpeas.core.silverstatistics.volume.model.StatType;
import org.silverpeas.core.silverstatistics.volume.model.StatisticsConfig;
import org.silverpeas.kernel.util.StringUtil;

public class AbstractSilverStatisticsDAO {
    protected AbstractSilverStatisticsDAO() {
    }

    protected static void insertData(Connection con, String tableName, StatType type, List<String> valueKeys, StatisticsConfig conf) throws SQLException {
        StringBuilder statementBuilder = new StringBuilder("INSERT INTO ");
        statementBuilder.append(tableName).append("(");
        List<String> theKeys = conf.getAllKeys(type);
        statementBuilder.append(String.join((CharSequence)",", theKeys));
        statementBuilder.append(") ");
        statementBuilder.append("VALUES(?");
        statementBuilder.append(",?".repeat(Math.max(0, conf.getNumberOfKeys(type) - 1)));
        statementBuilder.append(")");
        String statement = statementBuilder.toString();
        int i = 0;
        try (PreparedStatement prepStmt = con.prepareStatement(statement);){
            for (String currentKey : theKeys) {
                StatDataType currentType = StatDataType.valueOf(conf.getKeyType(type, currentKey));
                String tmpString = valueKeys.get(++i - 1);
                if (currentType == StatDataType.DECIMAL) {
                    AbstractSilverStatisticsDAO.setDecimalStatementParam(prepStmt, i, tmpString, currentKey, type, conf);
                }
                if (currentType == StatDataType.INTEGER) {
                    AbstractSilverStatisticsDAO.setIntegerStatementParam(prepStmt, i, tmpString, currentKey, type, conf);
                }
                if (currentType != StatDataType.VARCHAR) continue;
                AbstractSilverStatisticsDAO.setVarcharStatementParam(prepStmt, i, tmpString, currentKey);
            }
            prepStmt.executeUpdate();
        }
    }

    protected static Statements computeStatements(String tableName, StatType type, List<String> valueKeys, StatisticsConfig conf) {
        StringBuilder selectStatement = new StringBuilder("SELECT ");
        StringBuilder updateStatement = new StringBuilder("UPDATE ");
        updateStatement.append(tableName);
        updateStatement.append(" SET ");
        List<String> theKeys = conf.getAllKeys(type);
        Iterator<String> iteratorKeys = theKeys.iterator();
        AbstractSilverStatisticsDAO.prepareStatementHeader(selectStatement, updateStatement, tableName, iteratorKeys, type, conf);
        boolean stopputstat = false;
        boolean firstKeyInWhere = true;
        int k = -1;
        for (String keyNameCurrent : theKeys) {
            ++k;
            if (conf.isCumulKey(type, keyNameCurrent)) continue;
            if (!firstKeyInWhere) {
                selectStatement.append(" AND ");
                updateStatement.append(" AND ");
            }
            selectStatement.append(keyNameCurrent);
            updateStatement.append(keyNameCurrent);
            StatDataType currentType = StatDataType.valueOf(conf.getKeyType(type, keyNameCurrent));
            if (currentType == StatDataType.DECIMAL) {
                stopputstat = !StringUtil.isLong((String)valueKeys.get(k));
                AbstractSilverStatisticsDAO.setStatements(selectStatement, updateStatement, k, valueKeys, false);
            } else if (currentType == StatDataType.INTEGER) {
                stopputstat = !StringUtil.isInteger((String)valueKeys.get(k));
                AbstractSilverStatisticsDAO.setStatements(selectStatement, updateStatement, k, valueKeys, false);
            } else if (currentType == StatDataType.VARCHAR) {
                if (keyNameCurrent.equals("dateStat")) {
                    Object dateFirstDayOfMonth = valueKeys.get(k).substring(0, 8);
                    dateFirstDayOfMonth = (String)dateFirstDayOfMonth + "01";
                    selectStatement.append("='").append((String)dateFirstDayOfMonth).append("'");
                    updateStatement.append("='").append((String)dateFirstDayOfMonth).append("'");
                } else {
                    AbstractSilverStatisticsDAO.setStatements(selectStatement, updateStatement, k, valueKeys, true);
                }
            }
            firstKeyInWhere = false;
        }
        return new Statements(selectStatement, updateStatement, theKeys, stopputstat);
    }

    private static void prepareStatementHeader(StringBuilder selectStatement, StringBuilder updateStatement, String tableName, Iterator<String> iteratorKeys, StatType type, StatisticsConfig conf) {
        while (iteratorKeys.hasNext()) {
            String keyNameCurrent = iteratorKeys.next();
            selectStatement.append(keyNameCurrent);
            if (iteratorKeys.hasNext()) {
                selectStatement.append(",");
            }
            if (!conf.isCumulKey(type, keyNameCurrent)) continue;
            updateStatement.append(keyNameCurrent);
            updateStatement.append("=");
            if (tableName.endsWith("Cumul")) {
                updateStatement.append("? ,");
                continue;
            }
            updateStatement.append(keyNameCurrent).append("+? ,");
        }
        updateStatement.deleteCharAt(updateStatement.length() - 1);
        selectStatement.append(" FROM ").append(tableName).append(" WHERE ");
        updateStatement.append(" WHERE ");
    }

    private static void setStatements(StringBuilder selectStatement, StringBuilder updateStatement, int paramIndex, List<String> valueKeys, boolean isVarChar) {
        if (!StringUtil.isDefined((String)valueKeys.get(paramIndex))) {
            selectStatement.append("=NULL");
            updateStatement.append("=NULL");
        } else {
            selectStatement.append("=");
            updateStatement.append("=");
            if (isVarChar) {
                selectStatement.append("'").append(valueKeys.get(paramIndex)).append("'");
                updateStatement.append("'").append(valueKeys.get(paramIndex)).append("'");
            } else {
                selectStatement.append(valueKeys.get(paramIndex));
                updateStatement.append(valueKeys.get(paramIndex));
            }
        }
    }

    private static void setVarcharStatementParam(PreparedStatement prepStmt, int paramIndex, String paramValue, String currentKey) throws SQLException {
        if ("dateStat".equals(currentKey)) {
            String dateFirstDayOfMonth = paramValue.substring(0, 8) + "01";
            prepStmt.setString(paramIndex, dateFirstDayOfMonth);
        } else if (!StringUtil.isDefined((String)paramValue)) {
            prepStmt.setNull(paramIndex, 12);
        } else {
            prepStmt.setString(paramIndex, paramValue);
        }
    }

    private static void setIntegerStatementParam(PreparedStatement prepStmt, int paramIndex, String paramValue, String currentKey, StatType statsType, StatisticsConfig conf) throws SQLException {
        try {
            if (!StringUtil.isDefined((String)paramValue)) {
                if (!conf.isCumulKey(statsType, currentKey)) {
                    prepStmt.setNull(paramIndex, 4);
                } else {
                    prepStmt.setInt(paramIndex, 0);
                }
            } else {
                int tmpInt = Integer.parseInt(paramValue);
                prepStmt.setInt(paramIndex, tmpInt);
            }
        }
        catch (NumberFormatException e) {
            prepStmt.setInt(paramIndex, 0);
        }
    }

    private static void setDecimalStatementParam(PreparedStatement prepStmt, int paramIndex, String paramValue, String currentKey, StatType statsType, StatisticsConfig conf) throws SQLException {
        try {
            if (!StringUtil.isDefined((String)paramValue)) {
                if (!conf.isCumulKey(statsType, currentKey)) {
                    prepStmt.setNull(paramIndex, 3);
                } else {
                    prepStmt.setLong(paramIndex, 0L);
                }
            } else {
                long tmpLong = Long.parseLong(paramValue);
                prepStmt.setLong(paramIndex, tmpLong);
            }
        }
        catch (NumberFormatException e) {
            prepStmt.setLong(paramIndex, 0L);
        }
    }

    protected static class Statements {
        private final StringBuilder selectStatement;
        private final StringBuilder updateStatement;
        private final List<String> keys;
        private final boolean stopStatOp;

        public Statements(StringBuilder selectStatement, StringBuilder updateStatement, List<String> keys, boolean stopStatOp) {
            this.selectStatement = selectStatement;
            this.updateStatement = updateStatement;
            this.keys = keys;
            this.stopStatOp = stopStatOp;
        }

        public String getSelectStatement() {
            return this.selectStatement.toString();
        }

        public String getUpdateStatement() {
            return this.updateStatement.toString();
        }

        public boolean isStopStatOp() {
            return this.stopStatOp;
        }

        public List<String> getKeys() {
            return this.keys;
        }
    }
}

