/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Objects;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathRev
implements CacheValue,
Comparable<PathRev> {
    private static final Logger LOG = LoggerFactory.getLogger(PathRev.class);
    private final Path path;
    private final RevisionVector revision;
    private int hash;

    public PathRev(@NotNull Path path, @NotNull RevisionVector revision) {
        this.path = Objects.requireNonNull(path);
        this.revision = Objects.requireNonNull(revision);
    }

    public Path getPath() {
        return this.path;
    }

    public RevisionVector getRevision() {
        return this.revision;
    }

    public int getMemory() {
        long size = 24L + (long)this.path.getMemory() + (long)this.revision.getMemory();
        if (size > Integer.MAX_VALUE) {
            LOG.debug("Estimated memory footprint larger than Integer.MAX_VALUE: {}.", (Object)size);
            size = Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public int compareTo(@NotNull PathRev other) {
        if (this == other) {
            return 0;
        }
        int compare = this.path.compareTo(other.path);
        if (compare != 0) {
            return compare;
        }
        return this.revision.compareTo(other.revision);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 17;
            h = 37 * h + this.path.hashCode();
            this.hash = h = 37 * h + this.revision.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PathRev) {
            PathRev other = (PathRev)obj;
            return this.revision.equals(other.revision) && this.path.equals(other.path);
        }
        return false;
    }

    public String toString() {
        int dim = this.revision.getDimensions();
        StringBuilder sb = new StringBuilder(this.path.length() + (Revision.REV_STRING_APPROX_SIZE + 1) * dim);
        sb.append(this.path);
        sb.append("@");
        this.revision.toStringBuilder(sb);
        return sb.toString();
    }
}

