/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.AbstractPropertyState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompressedDocumentPropertyState
implements PropertyState {
    private static final Logger LOG = LoggerFactory.getLogger(CompressedDocumentPropertyState.class);
    private final DocumentNodeStore store;
    private final String name;
    private PropertyState parsed;
    private final byte[] compressedValue;
    private final Compression compression;
    private static int COMPRESSION_THRESHOLD = (Integer)SystemPropertySupplier.create((String)"oak.documentMK.stringCompressionThreshold ", (Object)-1).loggingTo(LOG).get();

    CompressedDocumentPropertyState(DocumentNodeStore store, String name, String value, Compression compression) {
        this.store = store;
        this.name = name;
        this.compression = compression;
        try {
            this.compressedValue = this.compress(value.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.warn("Failed to compress property {} value: ", (Object)name, (Object)e);
            throw new IllegalArgumentException("Failed to compress value", e);
        }
    }

    private byte[] compress(byte[] value) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStream compressionOutputStream = this.compression.getOutputStream((OutputStream)out);
        compressionOutputStream.write(value);
        compressionOutputStream.close();
        return out.toByteArray();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isArray() {
        return this.parsed().isArray();
    }

    public Type<?> getType() {
        return this.parsed().getType();
    }

    @NotNull
    public <T> T getValue(Type<T> type) {
        return (T)this.parsed().getValue(type);
    }

    @NotNull
    public <T> T getValue(Type<T> type, int index) {
        return (T)this.parsed().getValue(type, index);
    }

    public long size() {
        return this.parsed().size();
    }

    public long size(int index) {
        PropertyState parsed = this.parsed();
        long size = parsed.getType() == Type.BINARIES ? ((Blob)parsed.getValue(Type.BINARY, index)).length() : parsed.size(index);
        return size;
    }

    public int count() {
        return this.parsed().count();
    }

    @NotNull
    String getValue() {
        return this.decompress(this.compressedValue);
    }

    private String decompress(byte[] value) {
        try {
            return new String(this.compression.getInputStream((InputStream)new ByteArrayInputStream(value)).readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Failed to decompress property {} value: ", (Object)this.getName(), (Object)e);
            return "\"{}\"";
        }
    }

    byte[] getCompressedValue() {
        return this.compressedValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CompressedDocumentPropertyState) {
            CompressedDocumentPropertyState other = (CompressedDocumentPropertyState)object;
            if (!this.name.equals(other.name) || !Arrays.equals(this.compressedValue, other.compressedValue)) {
                return false;
            }
            if (this.compressedValue == null && other.compressedValue == null) {
                return this.getValue().equals(other.getValue());
            }
            if (this.compressedValue.length != other.compressedValue.length) {
                return false;
            }
            return Arrays.equals(this.compressedValue, other.compressedValue);
        }
        return object instanceof PropertyState && AbstractPropertyState.equal((PropertyState)this.parsed(), (PropertyState)((PropertyState)object));
    }

    public int hashCode() {
        return AbstractPropertyState.hashCode((PropertyState)this);
    }

    public String toString() {
        return AbstractPropertyState.toString((PropertyState)this);
    }

    static int getCompressionThreshold() {
        return COMPRESSION_THRESHOLD;
    }

    static void setCompressionThreshold(int compressionThreshold) {
        COMPRESSION_THRESHOLD = compressionThreshold;
    }

    private PropertyState parsed() {
        if (this.parsed == null) {
            JsopTokenizer reader = new JsopTokenizer(this.getValue());
            this.parsed = reader.matches(91) ? this.readArrayProperty(this.name, (JsopReader)reader) : this.readProperty(this.name, (JsopReader)reader);
        }
        return this.parsed;
    }

    PropertyState readProperty(String name, JsopReader reader) {
        return DocumentPropertyState.readProperty(name, this.store, reader);
    }

    PropertyState readArrayProperty(String name, JsopReader reader) {
        return DocumentPropertyState.readArrayProperty(name, this.store, reader);
    }
}

