/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class ListUtils {
    private ListUtils() {
    }

    @NotNull
    public static <T> List<T> toList(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        ArrayList result = new ArrayList();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <T> List<T> toLinkedList(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        LinkedList result = new LinkedList();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <T> List<T> toList(Iterator<? extends T> iterator) {
        Objects.requireNonNull(iterator);
        ArrayList result = new ArrayList();
        iterator.forEachRemaining(result::add);
        return result;
    }

    @NotNull
    public static <T> List<List<T>> partitionList(List<T> list, int n) {
        Objects.requireNonNull(list);
        return IntStream.range(0, list.size()).filter(i -> i % n == 0).mapToObj(i -> list.subList(i, Math.min(i + n, list.size()))).collect(Collectors.toList());
    }

    @NotNull
    public static <T> List<T> reverse(List<T> l) {
        Objects.requireNonNull(l);
        return IntStream.range(0, l.size()).map(i -> l.size() - 1 - i).mapToObj(l::get).collect(Collectors.toList());
    }
}

