/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.cdx;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Base64;
import java.util.BitSet;
import java.util.Formatter;
import java.util.HashMap;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MediaType;

public class CdxRequestEncoder {
    private static final int QUERY_STRING_LIMIT = 4096;
    private static final int BUFFER_SIZE = 65536;
    private static final BitSet percentPlusUnreserved = new BitSet();

    public static String encode(HttpRequest httpRequest) throws IOException {
        if (httpRequest.method().equals("GET")) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        out.append("__wb_method=");
        out.append(httpRequest.method());
        MediaType baseContentType = httpRequest.contentType().base();
        BufferedInputStream stream = new BufferedInputStream(httpRequest.body().stream(), 65536);
        if (baseContentType.equals(MediaType.WWW_FORM_URLENCODED)) {
            CdxRequestEncoder.encodeFormBody(stream, out);
        } else if (baseContentType.equals(MediaType.JSON)) {
            CdxRequestEncoder.encodeJsonBody(stream, out);
        } else {
            CdxRequestEncoder.encodeBinaryBody(stream, out);
        }
        return out.substring(0, Math.min(out.length(), 4096));
    }

    static void encodeBinaryBody(InputStream stream, StringBuilder out) throws IOException {
        byte[] body = IOUtils.readNBytes(stream, 4096);
        out.append("&__wb_post_data=");
        out.append(Base64.getEncoder().encodeToString(body));
    }

    private static void encodeFormBody(InputStream stream, StringBuilder out) throws IOException {
        stream.mark(65536);
        try {
            byte[] body = IOUtils.readNBytes(stream, 4096);
            String decodedBody = String.valueOf(StandardCharsets.UTF_8.newDecoder().decode(ByteBuffer.wrap(body)));
            out.append('&');
            out.append(URLDecoder.decode(decodedBody, "utf-8"));
        }
        catch (MalformedInputException e) {
            stream.reset();
            CdxRequestEncoder.encodeBinaryBody(stream, out);
        }
    }

    private static void encodeJsonBody(InputStream stream, StringBuilder output) throws IOException {
        stream.mark(65536);
        JsonParser parser = new JsonFactory().createParser(stream);
        HashMap<String, Long> nameCounts = new HashMap<String, Long>();
        ArrayDeque<String> nameStack = new ArrayDeque<String>();
        String name = null;
        try {
            block18: while (parser.nextToken() != null && output.length() < 4096) {
                switch (parser.currentToken()) {
                    case FIELD_NAME: {
                        name = parser.getCurrentName();
                        continue block18;
                    }
                    case VALUE_NULL: 
                    case VALUE_FALSE: 
                    case VALUE_TRUE: 
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_STRING: {
                        String encodedValue;
                        if (name == null) continue block18;
                        long serial = nameCounts.compute(name, (key, value) -> value == null ? 1L : value + 1L);
                        String key2 = name;
                        if (serial > 1L) {
                            key2 = key2 + "." + serial + "_";
                        }
                        output.append('&');
                        output.append(CdxRequestEncoder.percentPlusEncode(key2));
                        output.append('=');
                        switch (parser.currentToken()) {
                            case VALUE_NULL: {
                                encodedValue = "None";
                                break;
                            }
                            case VALUE_FALSE: {
                                encodedValue = "False";
                                break;
                            }
                            case VALUE_TRUE: {
                                encodedValue = "True";
                                break;
                            }
                            case VALUE_NUMBER_INT: {
                                encodedValue = String.valueOf(parser.getLongValue());
                                break;
                            }
                            case VALUE_NUMBER_FLOAT: {
                                encodedValue = String.valueOf(parser.getDoubleValue());
                                break;
                            }
                            default: {
                                encodedValue = CdxRequestEncoder.percentPlusEncode(parser.getValueAsString());
                            }
                        }
                        output.append(encodedValue);
                        continue block18;
                    }
                    case START_OBJECT: {
                        if (name == null) continue block18;
                        nameStack.push(name);
                        continue block18;
                    }
                    case END_OBJECT: {
                        name = nameStack.isEmpty() ? null : (String)nameStack.pop();
                        continue block18;
                    }
                    case START_ARRAY: 
                    case END_ARRAY: {
                        continue block18;
                    }
                }
                throw new IllegalStateException("Unexpected: " + parser.currentToken());
            }
        }
        catch (JsonParseException e) {
            try {
                stream.reset();
                CdxRequestEncoder.encodeBinaryBody(stream, output);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String percentPlusEncode(String string) {
        byte[] bytes;
        StringBuilder output = new StringBuilder();
        Formatter formatter = new Formatter(output);
        for (byte rawByte : bytes = string.getBytes(StandardCharsets.UTF_8)) {
            int b = rawByte & 0xFF;
            if (percentPlusUnreserved.get(b)) {
                output.append((char)b);
                continue;
            }
            if (b == 32) {
                output.append('+');
                continue;
            }
            output.append('%');
            formatter.format("%02X", b);
        }
        return output.toString();
    }

    static {
        "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~".chars().forEach(percentPlusUnreserved::set);
    }
}

