/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.guava.common.hash;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.guava.common.annotations.Beta;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.hash.HashCode;
import org.apache.jackrabbit.guava.common.hash.HashFunction;
import org.apache.jackrabbit.guava.common.hash.Hasher;
import org.apache.jackrabbit.guava.errorprone.annotations.CanIgnoreReturnValue;

@Beta
public final class HashingInputStream
extends FilterInputStream {
    private final Hasher hasher;

    public HashingInputStream(HashFunction hashFunction, InputStream in) {
        super(Preconditions.checkNotNull(in));
        this.hasher = Preconditions.checkNotNull(hashFunction.newHasher());
    }

    @Override
    @CanIgnoreReturnValue
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.hasher.putByte((byte)b);
        }
        return b;
    }

    @Override
    @CanIgnoreReturnValue
    public int read(byte[] bytes, int off, int len) throws IOException {
        int numOfBytesRead = this.in.read(bytes, off, len);
        if (numOfBytesRead != -1) {
            this.hasher.putBytes(bytes, off, numOfBytesRead);
        }
        return numOfBytesRead;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public HashCode hash() {
        return this.hasher.hash();
    }
}

