/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetReferencesResponseEncoder
extends MessageToByteEncoder<GetReferencesResponse> {
    private static final Logger log = LoggerFactory.getLogger(GetReferencesResponseEncoder.class);

    protected void encode(ChannelHandlerContext ctx, GetReferencesResponse msg, ByteBuf out) throws Exception {
        log.debug("Sending references of segment {} to client {}", (Object)msg.getSegmentId(), (Object)msg.getClientId());
        GetReferencesResponseEncoder.encode(msg.getSegmentId(), msg.getReferences(), out);
    }

    private static void encode(String segmentId, Iterable<String> references, ByteBuf out) {
        byte[] data = GetReferencesResponseEncoder.serialize(segmentId, references).getBytes(StandardCharsets.UTF_8);
        out.writeInt(data.length + 1);
        out.writeByte(3);
        out.writeBytes(data);
    }

    private static String serialize(String segmentId, Iterable<String> references) {
        return segmentId + ":" + String.join((CharSequence)",", references);
    }
}

