/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.segment.CacheWeights;
import org.apache.jackrabbit.oak.segment.RecordCache;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundExceptionListener;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.AbstractFileStore;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreProcBackend;
import org.apache.jackrabbit.oak.segment.file.GCListener;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.PriorityCache;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyRevisions;
import org.apache.jackrabbit.oak.segment.file.TarRevisions;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarPersistence;
import org.apache.jackrabbit.oak.segment.spi.monitor.CompositeIOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.tool.iotrace.IOTraceLogWriter;
import org.apache.jackrabbit.oak.segment.tool.iotrace.IOTraceMonitor;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.gc.DelegatingGCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.gc.LoggingGCMonitor;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(FileStore.class);
    private static final boolean MEMORY_MAPPING_DEFAULT = "64".equals(System.getProperty("sun.arch.data.model", "32"));
    public static final int DEFAULT_MAX_FILE_SIZE = 256;
    @NotNull
    private final File directory;
    @Nullable
    private BlobStore blobStore;
    private int maxFileSize = 256;
    private int segmentCacheSize = 256;
    private int stringCacheSize = 256;
    private int templateCacheSize = 64;
    private int stringDeduplicationCacheSize = WriterCacheManager.DEFAULT_STRING_CACHE_SIZE;
    private int templateDeduplicationCacheSize = WriterCacheManager.DEFAULT_TEMPLATE_CACHE_SIZE;
    private int nodeDeduplicationCacheSize = WriterCacheManager.DEFAULT_NODE_CACHE_SIZE;
    private boolean memoryMapping = MEMORY_MAPPING_DEFAULT;
    private boolean offHeapAccess = Boolean.getBoolean("access.off.heap");
    private int binariesInlineThreshold = 16512;
    private SegmentNodeStorePersistence persistence;
    @NotNull
    private StatisticsProvider statsProvider = StatisticsProvider.NOOP;
    @NotNull
    private SegmentGCOptions gcOptions = SegmentGCOptions.defaultGCOptions();
    @Nullable
    private EvictingWriteCacheManager cacheManager;
    @NotNull
    private final FileStoreGCListener gcListener = new FileStoreGCListener();
    @NotNull
    private SegmentNotFoundExceptionListener snfeListener = SegmentNotFoundExceptionListener.LOG_SNFE;
    @NotNull
    private final Set<IOMonitor> ioMonitors = new HashSet<IOMonitor>();
    @NotNull
    private RemoteStoreMonitor remoteStoreMonitor;
    private boolean strictVersionCheck;
    private boolean eagerSegmentCaching;
    private boolean built;

    @NotNull
    public static FileStoreBuilder fileStoreBuilder(@NotNull File directory) {
        return new FileStoreBuilder(directory);
    }

    private FileStoreBuilder(@NotNull File directory) {
        this.directory = Objects.requireNonNull(directory);
        this.gcListener.registerGCMonitor((GCMonitor)new LoggingGCMonitor(LOG));
        this.persistence = new TarPersistence(directory);
    }

    @NotNull
    public FileStoreBuilder withBlobStore(@NotNull BlobStore blobStore) {
        this.blobStore = Objects.requireNonNull(blobStore);
        return this;
    }

    @NotNull
    public FileStoreBuilder withMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    @NotNull
    public FileStoreBuilder withSegmentCacheSize(int segmentCacheSize) {
        this.segmentCacheSize = segmentCacheSize;
        return this;
    }

    @NotNull
    public FileStoreBuilder withStringCacheSize(int stringCacheSize) {
        this.stringCacheSize = stringCacheSize;
        return this;
    }

    @NotNull
    public FileStoreBuilder withTemplateCacheSize(int templateCacheSize) {
        this.templateCacheSize = templateCacheSize;
        return this;
    }

    @NotNull
    public FileStoreBuilder withStringDeduplicationCacheSize(int stringDeduplicationCacheSize) {
        this.stringDeduplicationCacheSize = stringDeduplicationCacheSize;
        return this;
    }

    @NotNull
    public FileStoreBuilder withTemplateDeduplicationCacheSize(int templateDeduplicationCacheSize) {
        this.templateDeduplicationCacheSize = templateDeduplicationCacheSize;
        return this;
    }

    @NotNull
    public FileStoreBuilder withNodeDeduplicationCacheSize(int nodeDeduplicationCacheSize) {
        this.nodeDeduplicationCacheSize = nodeDeduplicationCacheSize;
        return this;
    }

    @NotNull
    public FileStoreBuilder withMemoryMapping(boolean memoryMapping) {
        this.memoryMapping = memoryMapping;
        return this;
    }

    @NotNull
    public FileStoreBuilder withOffHeapAccess(boolean offHeapAccess) {
        this.offHeapAccess = offHeapAccess;
        return this;
    }

    @NotNull
    public FileStoreBuilder withDefaultMemoryMapping() {
        this.memoryMapping = MEMORY_MAPPING_DEFAULT;
        return this;
    }

    @NotNull
    public FileStoreBuilder withGCMonitor(@NotNull GCMonitor gcMonitor) {
        this.gcListener.registerGCMonitor(Objects.requireNonNull(gcMonitor));
        return this;
    }

    @NotNull
    public FileStoreBuilder withStatisticsProvider(@NotNull StatisticsProvider statisticsProvider) {
        this.statsProvider = Objects.requireNonNull(statisticsProvider);
        return this;
    }

    @NotNull
    public FileStoreBuilder withGCOptions(SegmentGCOptions gcOptions) {
        this.gcOptions = Objects.requireNonNull(gcOptions);
        return this;
    }

    @NotNull
    public FileStoreBuilder withSnfeListener(@NotNull SegmentNotFoundExceptionListener snfeListener) {
        this.snfeListener = Objects.requireNonNull(snfeListener);
        return this;
    }

    @NotNull
    public FileStoreBuilder withIOMonitor(@NotNull IOMonitor ioMonitor) {
        this.ioMonitors.add(Objects.requireNonNull(ioMonitor));
        return this;
    }

    @NotNull
    public FileStoreBuilder withRemoteStoreMonitor(@NotNull RemoteStoreMonitor remoteStoreMonitor) {
        this.remoteStoreMonitor = remoteStoreMonitor;
        return this;
    }

    @NotNull
    public FileStoreBuilder withIOLogging(@NotNull Logger logger) {
        if (logger.isDebugEnabled()) {
            this.ioMonitors.add(new IOTraceMonitor(new IOTraceLogWriter(logger)));
        }
        return this;
    }

    @NotNull
    public FileStoreBuilder withStrictVersionCheck(boolean strictVersionCheck) {
        this.strictVersionCheck = strictVersionCheck;
        return this;
    }

    public FileStoreBuilder withCustomPersistence(SegmentNodeStorePersistence persistence) {
        this.persistence = persistence;
        return this;
    }

    public FileStoreBuilder withEagerSegmentCaching(boolean eagerSegmentCaching) {
        this.eagerSegmentCaching = eagerSegmentCaching;
        return this;
    }

    public FileStoreBuilder withBinariesInlineThreshold(int binariesInlineThreshold) {
        this.binariesInlineThreshold = binariesInlineThreshold;
        return this;
    }

    public Proc.Backend buildProcBackend(AbstractFileStore fileStore) throws IOException {
        return new FileStoreProcBackend(fileStore, this.persistence);
    }

    @NotNull
    public FileStore build() throws InvalidFileStoreVersionException, IOException {
        FileStore store;
        Validate.checkState((!this.built ? 1 : 0) != 0, (Object)"Cannot re-use builder");
        this.built = true;
        this.directory.mkdirs();
        TarRevisions revisions = new TarRevisions(this.persistence);
        LOG.info("Creating file store {}", (Object)this);
        try {
            store = new FileStore(this);
        }
        catch (IOException | InvalidFileStoreVersionException e) {
            try {
                revisions.close();
            }
            catch (IOException re) {
                LOG.warn("Unable to close TarRevisions", (Throwable)re);
            }
            throw e;
        }
        store.bind(revisions);
        return store;
    }

    @NotNull
    public ReadOnlyFileStore buildReadOnly() throws InvalidFileStoreVersionException, IOException {
        ReadOnlyFileStore store;
        Validate.checkState((!this.built ? 1 : 0) != 0, (Object)"Cannot re-use builder");
        Validate.checkState((this.directory.exists() && this.directory.isDirectory() ? 1 : 0) != 0, (String)"%s does not exist or is not a directory", (Object[])new Object[]{this.directory});
        this.built = true;
        ReadOnlyRevisions revisions = new ReadOnlyRevisions(this.persistence);
        LOG.info("Creating file store {}", (Object)this);
        try {
            store = new ReadOnlyFileStore(this);
        }
        catch (IOException | InvalidFileStoreVersionException e) {
            try {
                revisions.close();
            }
            catch (IOException re) {
                LOG.warn("Unable to close ReadOnlyRevisions", (Throwable)re);
            }
            throw e;
        }
        store.bind(revisions);
        return store;
    }

    @NotNull
    File getDirectory() {
        return this.directory;
    }

    @Nullable
    BlobStore getBlobStore() {
        return this.blobStore;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    int getSegmentCacheSize() {
        return this.segmentCacheSize;
    }

    int getStringCacheSize() {
        return this.stringCacheSize;
    }

    int getTemplateCacheSize() {
        return this.templateCacheSize;
    }

    boolean getMemoryMapping() {
        return this.memoryMapping;
    }

    boolean getOffHeapAccess() {
        return this.offHeapAccess;
    }

    @NotNull
    GCListener getGcListener() {
        return this.gcListener;
    }

    @NotNull
    StatisticsProvider getStatsProvider() {
        return this.statsProvider;
    }

    @NotNull
    SegmentGCOptions getGcOptions() {
        return this.gcOptions;
    }

    @NotNull
    SegmentNotFoundExceptionListener getSnfeListener() {
        return this.snfeListener;
    }

    SegmentNodeStorePersistence getPersistence() {
        return this.persistence;
    }

    @NotNull
    public WriterCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = new EvictingWriteCacheManager(this.stringDeduplicationCacheSize, this.templateDeduplicationCacheSize, this.nodeDeduplicationCacheSize);
        }
        return this.cacheManager;
    }

    IOMonitor getIOMonitor() {
        return this.ioMonitors.isEmpty() ? new IOMonitorAdapter() : new CompositeIOMonitor(this.ioMonitors);
    }

    RemoteStoreMonitor getRemoteStoreMonitor() {
        if (this.remoteStoreMonitor == null) {
            return new RemoteStoreMonitorAdapter();
        }
        return this.remoteStoreMonitor;
    }

    boolean getStrictVersionCheck() {
        return this.strictVersionCheck;
    }

    boolean getEagerSegmentCaching() {
        return this.eagerSegmentCaching;
    }

    int getBinariesInlineThreshold() {
        return this.binariesInlineThreshold;
    }

    public String toString() {
        return "FileStoreBuilder{version=" + this.getClass().getPackage().getImplementationVersion() + ", directory=" + this.directory + ", blobStore=" + this.blobStore + ", binariesInlineThreshold=" + this.binariesInlineThreshold + ", maxFileSize=" + this.maxFileSize + ", segmentCacheSize=" + this.segmentCacheSize + ", stringCacheSize=" + this.stringCacheSize + ", templateCacheSize=" + this.templateCacheSize + ", stringDeduplicationCacheSize=" + this.stringDeduplicationCacheSize + ", templateDeduplicationCacheSize=" + this.templateDeduplicationCacheSize + ", nodeDeduplicationCacheSize=" + this.nodeDeduplicationCacheSize + ", memoryMapping=" + this.memoryMapping + ", offHeapAccess=" + this.offHeapAccess + ", gcOptions=" + this.gcOptions + "}";
    }

    private static class EvictingWriteCacheManager
    extends WriterCacheManager.Default {
        public EvictingWriteCacheManager(int stringCacheSize, int templateCacheSize, int nodeCacheSize) {
            super(RecordCache.factory(stringCacheSize, new CacheWeights.StringCacheWeigher()), RecordCache.factory(templateCacheSize, new CacheWeights.TemplateCacheWeigher()), PriorityCache.factory(nodeCacheSize, new CacheWeights.NodeCacheWeigher()));
        }

        void evictOldGeneration(int newGeneration) {
            this.evictCaches(generation -> generation < newGeneration);
        }

        void evictGeneration(int newGeneration) {
            this.evictCaches(generation -> generation == newGeneration);
        }
    }

    private class FileStoreGCListener
    extends DelegatingGCMonitor
    implements GCListener {
        private FileStoreGCListener() {
        }

        @Override
        public void compactionSucceeded(@NotNull GCGeneration newGeneration) {
            this.compacted();
            if (FileStoreBuilder.this.cacheManager != null) {
                FileStoreBuilder.this.cacheManager.evictOldGeneration(newGeneration.getGeneration());
            }
        }

        @Override
        public void compactionFailed(@NotNull GCGeneration failedGeneration) {
            if (FileStoreBuilder.this.cacheManager != null) {
                FileStoreBuilder.this.cacheManager.evictGeneration(failedGeneration.getGeneration());
            }
        }
    }
}

