/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentNodeBuilder
extends MemoryNodeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentNodeBuilder.class);
    private static final int UPDATE_LIMIT = Integer.getInteger("update.limit", 10000);
    @Nullable
    private final BlobStore blobStore;
    @NotNull
    private final SegmentReader reader;
    @NotNull
    private final SegmentWriter writer;
    private final MeterStats readStats;
    private long updateCount;

    SegmentNodeBuilder(@NotNull SegmentNodeState base, @Nullable BlobStore blobStore, @NotNull SegmentReader reader, @NotNull SegmentWriter writer, MeterStats readStats) {
        super((NodeState)base);
        this.blobStore = blobStore;
        this.reader = reader;
        this.writer = Objects.requireNonNull(writer);
        this.updateCount = 0L;
        this.readStats = readStats;
    }

    private SegmentNodeBuilder(@NotNull SegmentNodeBuilder parent, @NotNull String name, @Nullable BlobStore blobStore, @NotNull SegmentReader reader, @NotNull SegmentWriter writer, MeterStats readStats) {
        super((MemoryNodeBuilder)parent, name);
        this.blobStore = blobStore;
        this.reader = reader;
        this.writer = Objects.requireNonNull(writer);
        this.updateCount = -1L;
        this.readStats = readStats;
    }

    boolean isRootBuilder() {
        return this.isRoot();
    }

    protected void updated() {
        if (this.isChildBuilder()) {
            super.updated();
        } else {
            ++this.updateCount;
            if (this.updateCount > (long)UPDATE_LIMIT) {
                this.getNodeState();
            }
        }
    }

    private boolean isChildBuilder() {
        return this.updateCount < 0L;
    }

    @NotNull
    public SegmentNodeState getNodeState() {
        try {
            NodeState state = super.getNodeState();
            SegmentNodeState sState = new SegmentNodeState(this.reader, this.writer, this.blobStore, this.writer.writeNode(state), this.readStats);
            if (state != sState) {
                this.set(sState);
                if (!this.isChildBuilder()) {
                    this.updateCount = 0L;
                }
            }
            return sState;
        }
        catch (IOException e) {
            LOG.error("Error flushing changes", (Throwable)e);
            throw new IllegalStateException("Unexpected IOException", e);
        }
    }

    protected MemoryNodeBuilder createChildBuilder(String name) {
        return new SegmentNodeBuilder(this, name, this.blobStore, this.reader, this.writer, this.readStats);
    }

    public Blob createBlob(InputStream stream) throws IOException {
        return new SegmentBlob(this.blobStore, this.writer.writeStream(stream));
    }
}

