/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.jackrabbit.guava.common.cache.CacheBuilder;
import org.apache.jackrabbit.guava.common.cache.CacheStats;
import org.apache.jackrabbit.guava.common.cache.Weigher;
import org.apache.jackrabbit.oak.segment.Cache;
import org.apache.jackrabbit.oak.segment.CacheWeights;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.jetbrains.annotations.NotNull;

public abstract class RecordCache<K>
implements Cache<K, RecordId> {
    public abstract long size();

    public abstract long estimateCurrentWeight();

    @Override
    public void put(@NotNull K key, @NotNull RecordId value, byte cost) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public abstract CacheStats getStats();

    @NotNull
    public static <T> RecordCache<T> newRecordCache(int size) {
        if (size <= 0) {
            return new Empty();
        }
        return new Default(size, CacheWeights.noopWeigher());
    }

    @NotNull
    public static <T> Supplier<RecordCache<T>> factory(int size, @NotNull Weigher<T, RecordId> weigher) {
        if (size <= 0) {
            return Empty.emptyFactory();
        }
        return Default.defaultFactory(size, Objects.requireNonNull(weigher));
    }

    @NotNull
    public static <T> Supplier<RecordCache<T>> factory(int size) {
        if (size <= 0) {
            return Empty.emptyFactory();
        }
        return Default.defaultFactory(size, CacheWeights.noopWeigher());
    }

    private static class Default<K>
    extends RecordCache<K> {
        @NotNull
        private final org.apache.jackrabbit.guava.common.cache.Cache<K, RecordId> cache;
        @NotNull
        private final Weigher<K, RecordId> weigher;
        @NotNull
        private final LongAdder weight = new LongAdder();
        @NotNull
        private final LongAdder loadCount = new LongAdder();

        @Override
        @NotNull
        public CacheStats getStats() {
            CacheStats internalStats = this.cache.stats();
            return new CacheStats(internalStats.hitCount(), internalStats.missCount(), this.loadCount.sum(), 0L, 0L, internalStats.evictionCount());
        }

        static <K> Supplier<RecordCache<K>> defaultFactory(int size, @NotNull Weigher<K, RecordId> weigher) {
            return () -> new Default(size, Objects.requireNonNull(weigher));
        }

        Default(int size, @NotNull Weigher<K, RecordId> weigher) {
            this.cache = CacheBuilder.newBuilder().maximumSize((long)size * 4L / 3L).initialCapacity(size).concurrencyLevel(4).recordStats().removalListener(removal -> {
                int removedWeight = weigher.weigh(removal.getKey(), (Object)((RecordId)removal.getValue()));
                this.weight.add(-removedWeight);
            }).build();
            this.weigher = weigher;
        }

        @Override
        public void put(@NotNull K key, @NotNull RecordId value) {
            this.cache.put(key, (Object)value);
            this.loadCount.increment();
            this.weight.add(this.weigher.weigh(key, (Object)value));
        }

        @Override
        public RecordId get(@NotNull K key) {
            return (RecordId)this.cache.getIfPresent(key);
        }

        @Override
        public long size() {
            return this.cache.size();
        }

        @Override
        public long estimateCurrentWeight() {
            return this.weight.sum();
        }
    }

    private static class Empty<T>
    extends RecordCache<T> {
        @NotNull
        private final LongAdder missCount = new LongAdder();

        private Empty() {
        }

        static final <T> Supplier<RecordCache<T>> emptyFactory() {
            return Empty::new;
        }

        @Override
        @NotNull
        public CacheStats getStats() {
            return new CacheStats(0L, this.missCount.sum(), 0L, 0L, 0L, 0L);
        }

        @Override
        public void put(@NotNull T key, @NotNull RecordId value) {
        }

        @Override
        public RecordId get(@NotNull T key) {
            this.missCount.increment();
            return null;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public long estimateCurrentWeight() {
            return -1L;
        }
    }
}

