/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.model;

import org.silverpeas.components.mailinglist.service.MailingListServicesProvider;
import org.silverpeas.components.mailinglist.service.event.MessageEvent;
import org.silverpeas.components.mailinglist.service.event.MessageListener;
import org.silverpeas.components.mailinglist.service.model.beans.MailingList;
import org.silverpeas.components.mailinglist.service.model.beans.Message;
import org.silverpeas.components.mailinglist.service.notification.NotificationHelper;
import org.silverpeas.kernel.logging.SilverLogger;

public class MailingListComponent
implements MessageListener {
    private String componentId;

    public MailingListComponent(String componentId) {
        this.componentId = componentId;
    }

    @Override
    public boolean checkSender(String email) {
        MailingList list = MailingListServicesProvider.getMailingListService().findMailingList(this.componentId);
        return list.isOpen() || list.isEmailAuthorized(email);
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @Override
    public void onMessage(MessageEvent event) {
        if (event == null || event.getMessages() == null || event.getMessages().isEmpty()) {
            return;
        }
        MailingList list = MailingListServicesProvider.getMailingListService().findMailingList(this.componentId);
        for (Message message : event.getMessages()) {
            message.setModerated(!list.isModerated());
            MailingListServicesProvider.getMessageService().saveMessage(message);
        }
        if (list.isNotify() || list.isModerated()) {
            NotificationHelper helper = MailingListServicesProvider.getNotificationHelper();
            for (Message message : event.getMessages()) {
                try {
                    helper.notify(message, list);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error((Throwable)e);
                }
            }
        }
    }
}

