/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authorization;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.util.ServiceProvider;

public interface ComponentAuthorization {
    public static Set<ComponentAuthorization> getAll() {
        return ServiceProvider.getAllServices(ComponentAuthorization.class, new Annotation[0]);
    }

    public boolean isRelatedTo(String var1);

    public <T> Stream<T> filter(Collection<T> var1, Function<T, ComponentResourceReference> var2, String var3, AccessControlOperation ... var4);

    public static class ComponentResourceReference {
        final String localId;
        final String type;
        final String instanceId;

        public ComponentResourceReference(String localId, String type, String instanceId) {
            this.localId = localId;
            this.type = type;
            this.instanceId = instanceId;
        }

        public String getLocalId() {
            return this.localId;
        }

        public String getType() {
            return this.type;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentResourceReference that = (ComponentResourceReference)o;
            return this.localId.equals(that.localId) && Objects.equals(this.type, that.type) && this.instanceId.equals(that.instanceId);
        }

        public int hashCode() {
            return Objects.hash(this.localId, this.type, this.instanceId);
        }
    }
}

