/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc.sql.setters;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.date.DateTime;
import org.silverpeas.core.persistence.jdbc.sql.setters.SqlTemporalParamSetter;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
class SqlDateTimeParamSetter
extends SqlTemporalParamSetter {
    SqlDateTimeParamSetter() {
    }

    @Override
    public List<Class<?>> getSupportedTypes() {
        return Arrays.asList(Timestamp.class, DateTime.class, Instant.class, LocalDateTime.class, OffsetDateTime.class, ZonedDateTime.class);
    }

    @Override
    public void setParameter(PreparedStatement statement, int idx, Object value) throws SQLException {
        if (value instanceof Timestamp) {
            statement.setTimestamp(idx, (Timestamp)value);
        } else if (this.isADateTime(value)) {
            statement.setTimestamp(idx, Timestamp.from(this.toInstant(value)));
        } else {
            this.throwTypeNotSupported(value.getClass());
        }
    }

    private boolean isADateTime(Object parameter) {
        if (parameter instanceof DateTime) {
            return true;
        }
        if (parameter instanceof Instant) {
            return true;
        }
        if (parameter instanceof LocalDateTime) {
            return true;
        }
        if (parameter instanceof OffsetDateTime) {
            return true;
        }
        return parameter instanceof ZonedDateTime;
    }
}

