/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.system;

import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.kernel.logging.SilverLogger;

public interface ResourceEventListener<T extends ResourceEvent<?>> {
    default public void onDeletion(T event) {
    }

    default public void onRemoving(T event) {
    }

    default public void onRecovery(T event) {
    }

    default public void onUpdate(T event) {
    }

    default public void onMove(T event) {
    }

    default public void onCreation(T event) {
    }

    default public void onUnlock(T event) {
    }

    default public void dispatchEvent(T event) {
        if (this.isEnabled()) {
            switch (event.getType()) {
                case CREATION: {
                    this.onCreation(event);
                    break;
                }
                case UPDATE: {
                    this.onUpdate(event);
                    break;
                }
                case MOVE: {
                    this.onMove(event);
                    break;
                }
                case UNLOCK: {
                    this.onUnlock(event);
                    break;
                }
                case REMOVING: {
                    this.onRemoving(event);
                    break;
                }
                case DELETION: {
                    this.onDeletion(event);
                    break;
                }
                case RECOVERY: {
                    this.onRecovery(event);
                    break;
                }
                default: {
                    SilverLogger.getLogger((Object)this).warn("Event type {0} not yet supported", new Object[]{event.getType().toString()});
                }
            }
        }
    }

    default public boolean isEnabled() {
        return true;
    }
}

