/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.sse;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.sse.ServerEvent;
import org.silverpeas.core.notification.sse.ServerEventDispatcherTask;
import org.silverpeas.core.notification.sse.SseLogger;
import org.silverpeas.core.notification.sse.behavior.SendEveryAmountOfTime;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.scheduler.trigger.TimeUnit;
import org.silverpeas.core.util.Process;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class ServerEventWaitForManager {
    private static final ConcurrentMap<String, CacheContext> contextsByEventType = new ConcurrentHashMap<String, CacheContext>();

    ServerEventWaitForManager() {
    }

    public static ServerEventWaitForManager get() {
        return ServiceProvider.getService(ServerEventWaitForManager.class, new Annotation[0]);
    }

    public boolean mustSendImmediately(ServerEvent event) {
        SendEveryAmountOfTime serverEvent;
        boolean mustSendImmediately;
        int delayInSeconds = event instanceof SendEveryAmountOfTime ? NotificationManagerSettings.sendEveryAmountOfSecondsFor(event.getName()) : -1;
        boolean bl = mustSendImmediately = delayInSeconds <= 0;
        if (!mustSendImmediately && !(mustSendImmediately = (serverEvent = (SendEveryAmountOfTime)event).hasWaitingFor())) {
            String eventType = serverEvent.getStoreDiscriminator();
            mustSendImmediately = contextsByEventType.computeIfAbsent(eventType, t -> {
                SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - added into cache of contexts", t));
                return new CacheContext((String)t);
            }).setEvent(serverEvent);
        }
        return mustSendImmediately;
    }

    private static class CacheContext
    implements Serializable {
        private static final long serialVersionUID = 679271503199577304L;
        private final Semaphore semaphore = new Semaphore(1, true);
        private final String eventType;
        private transient SendEveryAmountOfTime event;
        private int count = -1;

        public CacheContext(String eventType) {
            this.eventType = eventType;
        }

        private boolean setEvent(SendEveryAmountOfTime event) {
            event.markAsWaitingFor();
            return this.safeExecute("CONTEXT - try set event into context", "CONTEXT - event set into context", () -> {
                boolean mustSendImmediately = false;
                if (this.count == -1) {
                    SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - CONTEXT - first event after context initialization is sent immediately", this.eventType));
                    mustSendImmediately = true;
                    this.count = 0;
                    new ServerEventJob(event).setOrVerifyJobDelay();
                } else if (this.count == 0) {
                    SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - CONTEXT - first event waiting for job execution", this.eventType));
                } else {
                    SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - CONTEXT - new event replacing a previous to wait for job execution ({1} replacements)", this.eventType, String.valueOf(this.count)));
                }
                this.event = event;
                ++this.count;
                return mustSendImmediately;
            });
        }

        private void consumeEvent(String acquireMsg, String releaseMsg, Predicate<Optional<SendEveryAmountOfTime>> function) {
            this.safeExecute(acquireMsg, releaseMsg, () -> {
                if (!Boolean.TRUE.equals(function.test(Optional.ofNullable(this.event)))) {
                    contextsByEventType.remove(this.eventType);
                    SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - CONTEXT - removed from cache of contexts", this.eventType));
                }
                this.event = null;
                this.count = 0;
                return null;
            });
        }

        private <T> T safeExecute(String acquireMsg, String releaseMsg, Process<T> process) {
            SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - {1} ({2} are waiting)", this.eventType, acquireMsg, String.valueOf(this.semaphore.getQueueLength())));
            try {
                this.semaphore.acquire();
                T t = process.execute();
                return t;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SilverpeasRuntimeException((Throwable)e);
            }
            catch (Exception e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
            finally {
                this.semaphore.release();
                SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - {1} ({2} are waiting)", this.eventType, releaseMsg, String.valueOf(this.semaphore.getQueueLength())));
            }
        }
    }

    static class ServerEventJob
    extends Job {
        private final ServerEvent.ServerEventName eventName;
        private final String eventType;
        private Integer delayInSeconds = -1;

        private ServerEventJob(SendEveryAmountOfTime event) {
            super("SEE_JOB_FOR_EVENT_" + event.getStoreDiscriminator());
            this.eventName = event.getName();
            this.eventType = event.getStoreDiscriminator();
        }

        private boolean setOrVerifyJobDelay() {
            boolean scheduled = false;
            int newDelayInSeconds = NotificationManagerSettings.sendEveryAmountOfSecondsFor(this.eventName);
            if (newDelayInSeconds > 0) {
                try {
                    if (this.delayInSeconds != newDelayInSeconds) {
                        Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
                        if (this.delayInSeconds != -1) {
                            SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - JOB - stopping because of changed delay", this.eventType));
                            scheduler.unscheduleJob(this.getName());
                        }
                        scheduler.scheduleJob(this, JobTrigger.triggerEvery(newDelayInSeconds, TimeUnit.SECOND));
                        SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - JOB - starting to be invoked every {1} seconds", this.eventType, String.valueOf(newDelayInSeconds)));
                    }
                }
                catch (SchedulerException e) {
                    SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
                }
                this.delayInSeconds = newDelayInSeconds;
                scheduled = true;
            } else {
                try {
                    SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - JOB - stopping because of deactivation", this.eventType));
                    SchedulerProvider.getVolatileScheduler().unscheduleJob(this.getName());
                }
                catch (SchedulerException e) {
                    SseLogger.get().error((Throwable)((Object)e));
                }
                this.delayInSeconds = -1;
            }
            return scheduled;
        }

        @Override
        public void execute(JobExecutionContext context) {
            ((CacheContext)contextsByEventType.get(this.eventType)).consumeEvent("JOB - starts invoke", "JOB - ends invoke", event -> {
                if (event.isPresent()) {
                    SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - JOB - dispatch last event waiting for", this.eventType));
                    ServerEventDispatcherTask.dispatch((ServerEvent)event.get());
                } else {
                    SseLogger.get().debug(() -> MessageFormat.format("WAIT FOR - {0} - JOB - no event to dispatch", this.eventType));
                }
                return this.setOrVerifyJobDelay();
            });
        }
    }
}

