/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.media.streaming;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StreamingProvider
implements Serializable {
    private static final long serialVersionUID = 3725979193939989226L;
    private final String name;
    private final Pattern urlIdExtractorRegexpPattern;
    private final String oembedUrlStringPattern;
    private final boolean justIdInOembedUrl;
    private final List<Pattern> regexpDetectionParts;

    public StreamingProvider(String name, Pattern urlIdExtractorRegexpPattern, String oembedUrlStringPattern, boolean justIdInOembedUrl, List<Pattern> regexpDetectionParts) {
        this.name = name;
        this.urlIdExtractorRegexpPattern = urlIdExtractorRegexpPattern;
        this.oembedUrlStringPattern = oembedUrlStringPattern;
        this.justIdInOembedUrl = justIdInOembedUrl;
        this.regexpDetectionParts = regexpDetectionParts;
    }

    public String getName() {
        return this.name;
    }

    String getOembedUrlStringPattern() {
        return this.oembedUrlStringPattern;
    }

    public List<Pattern> getRegexpDetectionParts() {
        return this.regexpDetectionParts;
    }

    Optional<String> extractStreamingId(String url) {
        if (!this.justIdInOembedUrl) {
            return Optional.of(url);
        }
        int matchedGroup = 2;
        Matcher matcher = this.urlIdExtractorRegexpPattern.matcher(url);
        if (matcher.find()) {
            return Optional.of(matcher.group(2));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamingProvider that = (StreamingProvider)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

