/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.date;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;

public enum TimeUnit implements TemporalUnit
{
    MILLISECOND,
    SECOND,
    MINUTE,
    HOUR,
    DAY,
    WEEK,
    MONTH,
    YEAR;


    public ChronoUnit toChronoUnit() {
        switch (this) {
            case MILLISECOND: {
                return ChronoUnit.MILLIS;
            }
            case SECOND: {
                return ChronoUnit.SECONDS;
            }
            case MINUTE: {
                return ChronoUnit.MINUTES;
            }
            case HOUR: {
                return ChronoUnit.HOURS;
            }
            case DAY: {
                return ChronoUnit.DAYS;
            }
            case WEEK: {
                return ChronoUnit.WEEKS;
            }
            case MONTH: {
                return ChronoUnit.MONTHS;
            }
            case YEAR: {
                return ChronoUnit.YEARS;
            }
        }
        throw new IllegalStateException("Unknown time unit: " + this.name());
    }

    @Override
    public Duration getDuration() {
        return this.toChronoUnit().getDuration();
    }

    @Override
    public boolean isDurationEstimated() {
        return this.toChronoUnit().isDurationEstimated();
    }

    @Override
    public boolean isDateBased() {
        return this.toChronoUnit().isDateBased();
    }

    @Override
    public boolean isTimeBased() {
        return this.toChronoUnit().isTimeBased();
    }

    @Override
    public <R extends Temporal> R addTo(R temporal, long amount) {
        return this.toChronoUnit().addTo(temporal, amount);
    }

    @Override
    public long between(Temporal temporal1Inclusive, Temporal temporal2Exclusive) {
        return temporal1Inclusive.until(temporal2Exclusive, this);
    }
}

