/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.contribution.ContributionLocatorByLocalIdAndType;
import org.silverpeas.core.contribution.model.ContributionIdentifier;

@Named
public class CalendarContributionLocator
implements ContributionLocatorByLocalIdAndType {
    private static final List<String> HANDLED_TYPES = Arrays.asList("CalendarEvent", "CalendarEventOccurrence");

    @Override
    public boolean isContributionLocatorOfType(String type) {
        return HANDLED_TYPES.contains(type);
    }

    @Override
    public Optional<ContributionIdentifier> getContributionIdentifierFromLocalIdAndType(String localId, String type) {
        ContributionIdentifier contributionIdentifier = null;
        if ("CalendarEvent".equals(type)) {
            CalendarEvent event = CalendarEvent.getById(localId);
            if (event != null) {
                contributionIdentifier = event.getIdentifier();
            }
        } else {
            CalendarEventOccurrence occurrence = CalendarEventOccurrence.getById(localId).orElse(null);
            if (occurrence != null) {
                contributionIdentifier = occurrence.getIdentifier();
            }
        }
        return Optional.ofNullable(contributionIdentifier);
    }
}

