/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ChannelURL;
import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.appengine.PortletAppEngineUtils;
import com.sun.portal.portletcontainer.common.PortletContainerRequest;
import com.sun.portal.portletcontainer.common.URLHelper;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.BaseURL;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseURLImpl
implements BaseURL {
    private PortletRequest portletRequest;
    private ChannelURL portletWindowURL;
    private PortletAppDescriptor portletAppDescriptor;
    private PortletDescriptor portletDescriptor;
    private String action;
    private Boolean escapeXml;
    private static Logger logger = ContainerLogger.getLogger(BaseURLImpl.class, (String)"PAELogMessages");

    protected void init(PortletRequest portletRequest, PortletContainerRequest pcRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor, String action) {
        this.portletRequest = portletRequest;
        ChannelURLFactory channelURLFactory = pcRequest.getPortletWindowURLFactory();
        if (channelURLFactory != null) {
            this.portletWindowURL = channelURLFactory.createChannelURL();
            if (this.portletWindowURL != null) {
                this.portletWindowURL.setURLType(PortletAppEngineUtils.getURLType(action));
            }
        } else {
            logger.log(Level.SEVERE, "PSPL_PAECSPPI0023", pcRequest.getEntityID());
        }
        this.portletAppDescriptor = portletAppDescriptor;
        this.portletDescriptor = portletDescriptor;
        this.action = action;
        String[] escapeXmlValue = this.portletAppDescriptor.getContainerRuntimeOption(this.portletDescriptor.getPortletID(), "javax.portlet.escapeXml");
        if (escapeXmlValue != null) {
            this.escapeXml = Boolean.valueOf(escapeXmlValue[0]);
            this.portletRequest.setAttribute("javax.portlet.portletc.escapeXmlValue", (Object)this.escapeXml);
        }
    }

    protected PortletRequest getPortletRequest() {
        return this.portletRequest;
    }

    protected ChannelURL getChannelURL() {
        return this.portletWindowURL;
    }

    protected PortletDescriptor getPortletDescriptor() {
        return this.portletDescriptor;
    }

    protected PortletAppDescriptor getPortletAppDescriptor() {
        return this.portletAppDescriptor;
    }

    protected String getAction() {
        return this.action;
    }

    public Map<String, String[]> getParameterMap() {
        Map map = this.getChannelURL().getParameters();
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public void setParameter(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("The parameter name cannot be null.");
        }
        if (value == null) {
            this.getChannelURL().setParameter(name, (String)null);
        } else {
            QName publicRenderParameterQName = this.portletAppDescriptor.getPublicRenderParameterQName(name);
            if (publicRenderParameterQName != null) {
                Map<String, String[]> map = this.getParameterMap();
                String[] values = map.get(name);
                if (values != null) {
                    LinkedList<String> list = new LinkedList<String>(Arrays.asList(values));
                    list.addFirst(value);
                    values = list.toArray(new String[0]);
                    this.setParameter(name, values);
                } else {
                    this.getChannelURL().setParameter(name, value);
                }
            } else {
                this.getChannelURL().setParameter(name, value);
            }
        }
    }

    public void setParameter(String name, String[] values) {
        if (name == null || values == null) {
            throw new IllegalArgumentException("The parameter name or values cannot be null.");
        }
        QName publicRenderParameterQName = this.portletAppDescriptor.getPublicRenderParameterQName(name);
        if (publicRenderParameterQName != null) {
            Map<String, String[]> map = this.getParameterMap();
            String[] existingValues = map.get(name);
            if (existingValues != null) {
                LinkedList<String> list = new LinkedList<String>(Arrays.asList(existingValues));
                for (int i = 0; i < values.length; ++i) {
                    list.addFirst(values[i]);
                }
                existingValues = list.toArray(new String[0]);
                this.setParameter(name, existingValues);
            } else {
                this.getChannelURL().setParameter(name, values);
            }
        } else {
            this.getChannelURL().setParameter(name, values);
        }
    }

    public void setParameters(Map<String, String[]> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Cannot set parameter with null map object.");
        }
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String[] val = entry.getValue();
            if (key instanceof String && val instanceof String[]) continue;
            throw new IllegalArgumentException("Parameter keys should be type String and values should be type String[].");
        }
        this.getChannelURL().setParameters(parameters);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        if (secure && !this.getPortletRequest().isSecure()) {
            throw new PortletSecurityException("The Portal Server is not running on secure mode");
        }
        this.getChannelURL().setSecure(secure);
    }

    public String toString() {
        String portletURLString = this.getChannelURL().toString();
        if (this.escapeXml != null && this.escapeXml.booleanValue()) {
            return URLHelper.escapeURL(portletURLString);
        }
        return portletURLString;
    }

    public void write(Writer out) throws IOException {
        this.write(out, true);
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        String urlString = this.toString();
        if (this.escapeXml != null) {
            escapeXML = this.escapeXml;
        }
        if (escapeXML) {
            urlString = URLHelper.escapeURL(urlString);
        }
        out.write(urlString);
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        this.getChannelURL().addProperty(key, value);
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        this.getChannelURL().setProperty(key, value);
    }
}

