/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.PortletEvent;
import com.sun.portal.portletcontainer.appengine.PortletAppEngineUtils;
import com.sun.portal.portletcontainer.common.PortletContainerActionRequest;
import com.sun.portal.portletcontainer.common.PortletContainerActionResponse;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.StateAwareResponseImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionResponseImpl
extends StateAwareResponseImpl
implements ActionResponse {
    private PortletContainerActionRequest pcActionRequest;
    private PortletContainerActionResponse pcActionResponse;
    private ActionRequest actionRequest;
    private boolean sendRedirectIsCalled = false;
    private boolean setMethodIsCalled = false;
    private static Logger logger = ContainerLogger.getLogger(ActionResponseImpl.class, (String)"PAELogMessages");

    protected void init(HttpServletRequest request, HttpServletResponse response, PortletContainerActionRequest pcActionRequest, PortletContainerActionResponse pcActionResponse, ActionRequest actionRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor) {
        super.init(request, response, pcActionRequest, pcActionResponse, (PortletRequest)actionRequest, portletAppDescriptor, portletDescriptor);
        this.actionRequest = actionRequest;
        this.pcActionRequest = pcActionRequest;
        this.pcActionResponse = pcActionResponse;
        this.sendRedirectIsCalled = false;
        this.setMethodIsCalled = false;
    }

    @Override
    protected void clear() {
        super.clear();
        this.actionRequest = null;
        this.pcActionRequest = null;
        this.pcActionResponse = null;
        this.sendRedirectIsCalled = false;
        this.setMethodIsCalled = false;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!this.actionRequest.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Invalid setting window state", windowState);
        }
        if (this.sendRedirectIsCalled) {
            throw new IllegalStateException("Illegal to set window state after sendRedirect is called.");
        }
        this.setMethodIsCalled = true;
        this.pcActionResponse.setChannelState(PortletAppEngineUtils.getChannelState(windowState));
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (!this.actionRequest.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException("Attempt to set an invalid portlet mode: ", portletMode);
        }
        if (this.sendRedirectIsCalled) {
            throw new IllegalStateException("Illegal to set portlet mode after sendRedirect is called.");
        }
        this.setMethodIsCalled = true;
        this.pcActionResponse.setChannelMode(PortletAppEngineUtils.getChannelMode(portletMode));
    }

    public void sendRedirect(String location) throws IOException {
        if (this.setMethodIsCalled) {
            throw new IllegalStateException("Illegal to sendRedirect after setting window state, portlet mode, or render parameters.");
        }
        URL retURL = null;
        try {
            retURL = new URL(this.getLocationURL(location));
        }
        catch (MalformedURLException mfue) {
            throw new IllegalArgumentException(mfue.getMessage());
        }
        this.sendRedirectIsCalled = true;
        this.pcActionResponse.setRedirectURL(retURL);
    }

    public void sendRedirect(String location, String renderUrlParamName) throws IOException {
        if (this.setMethodIsCalled) {
            throw new IllegalStateException("Illegal to sendRedirect after setting window state, portlet mode, or render parameters.");
        }
        URL retURL = null;
        try {
            String renderURL = this.getCurrentRenderURL();
            StringBuffer urlBuffer = new StringBuffer(this.getLocationURL(location));
            if (urlBuffer.indexOf("?") != -1) {
                urlBuffer.append("&");
                urlBuffer.append(renderUrlParamName);
                urlBuffer.append("=");
                urlBuffer.append(renderURL);
            } else {
                urlBuffer.append("?");
                urlBuffer.append(renderUrlParamName);
                urlBuffer.append("=");
                urlBuffer.append(renderURL);
            }
            retURL = new URL(urlBuffer.toString());
        }
        catch (MalformedURLException mfue) {
            throw new IllegalArgumentException(mfue.getMessage());
        }
        this.sendRedirectIsCalled = true;
        this.pcActionResponse.setRedirectURL(retURL);
    }

    private String getLocationURL(String location) {
        if (location.indexOf("://") == -1) {
            StringBuffer b = new StringBuffer(128);
            b.append(this.pcActionRequest.getHttpServletRequest().getScheme());
            b.append("://");
            b.append(this.pcActionRequest.getHttpServletRequest().getServerName());
            b.append(":");
            b.append(this.pcActionRequest.getHttpServletRequest().getServerPort());
            b.append(location);
            location = b.toString();
        }
        return location;
    }

    public void setRenderParameters(Map parameters) {
        if (this.sendRedirectIsCalled) {
            throw new IllegalStateException("Illegal to set parameters after sendRedirect is called.");
        }
        this.checkRenderParameterMap(parameters);
        this.setMethodIsCalled = true;
        this.pcActionResponse.setRenderParameters(parameters);
    }

    public void setRenderParameter(String key, String value) {
        if (this.sendRedirectIsCalled) {
            throw new IllegalStateException("Illegal to set parameter after sendRedirect is called.");
        }
        List<String> deletedRenderParameters = this.getDeletedRenderParameterList(key, value, this.pcActionResponse.getDeletedRenderParameters());
        this.pcActionResponse.setDeletedRenderParameters(deletedRenderParameters);
        Map<String, String[]> renderMap = this.getRenderParameterMap(key, value, this.pcActionResponse.getRenderParameters());
        this.pcActionResponse.setRenderParameters(renderMap);
        this.setMethodIsCalled = true;
    }

    public void setRenderParameter(String key, String[] values) {
        if (this.sendRedirectIsCalled) {
            throw new IllegalStateException("Illegal to set parameter after sendRedirect is called.");
        }
        Map<String, String[]> renderMap = this.getRenderParameterMap(key, values, this.pcActionResponse.getRenderParameters());
        this.pcActionResponse.setRenderParameters(renderMap);
        this.setMethodIsCalled = true;
    }

    public Map<String, String[]> getRenderParameterMap() {
        Map<String, String[]> map = this.pcActionResponse.getRenderParameters();
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public PortletMode getPortletMode() {
        return PortletAppEngineUtils.getPortletMode(this.pcActionResponse.getChannelMode());
    }

    public WindowState getWindowState() {
        return PortletAppEngineUtils.getWindowState(this.pcActionResponse.getChannelState());
    }

    public void removePublicRenderParameter(String name) {
        if (this.checkIfPublicRenderParameter(name)) {
            List<String> deletedRenderParameters = this.getDeletedRenderParameterList(name, null, this.pcActionResponse.getDeletedRenderParameters());
            this.pcActionResponse.setDeletedRenderParameters(deletedRenderParameters);
        }
    }

    @Override
    protected void setEventQueue(PortletEvent event) {
        ConcurrentLinkedQueue<PortletEvent> eventQueue = (ConcurrentLinkedQueue<PortletEvent>)this.actionRequest.getAttribute("com.sun.portal.portletcontainer.events");
        if (eventQueue == null) {
            eventQueue = new ConcurrentLinkedQueue<PortletEvent>();
        }
        eventQueue.offer(event);
        this.actionRequest.setAttribute("com.sun.portal.portletcontainer.events", eventQueue);
    }

    private String getCurrentRenderURL() {
        PortletURL renderURL = this.createRenderURL();
        try {
            Map<String, String[]> map;
            if (this.getPortletMode() != null) {
                renderURL.setPortletMode(this.getPortletMode());
            }
            if (this.getWindowState() != null) {
                renderURL.setWindowState(this.getWindowState());
            }
            if ((map = this.getRenderParameterMap()) != null) {
                renderURL.setParameters(map);
                Set<Map.Entry<String, String[]>> entries = map.entrySet();
                for (Map.Entry<String, String[]> mapEntry : entries) {
                    if (!this.checkIfPublicRenderParameter(mapEntry.getKey())) continue;
                    renderURL.setParameter(mapEntry.getKey(), mapEntry.getValue());
                }
            }
        }
        catch (PortletModeException e) {
            logger.log(Level.WARNING, "PSPL_PAECSPPI0035", e);
        }
        catch (WindowStateException e) {
            logger.log(Level.WARNING, "PSPL_PAECSPPI0036", e);
        }
        return renderURL.toString();
    }
}

