/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportsDescriptor {
    public static final String MIME_TYPE = "mime-type";
    public static final String PORTLET_MODE = "portlet-mode";
    private String mimeType;
    private List<String> portletModes = new ArrayList<String>();

    public void load(Element element, String namespaceURI) {
        this.mimeType = PortletXMLDocumentHelper.getChildTextTrim(element, MIME_TYPE);
        List<Element> modeElements = PortletXMLDocumentHelper.getChildElements(element, PORTLET_MODE);
        if (modeElements != null) {
            int numMode = modeElements.size();
            for (int i = 0; i < numMode; ++i) {
                Element modeElement = modeElements.get(i);
                this.portletModes.add(PortletXMLDocumentHelper.getTextTrim(modeElement).toUpperCase(Locale.ENGLISH));
            }
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public List<String> getPortletModes() {
        return this.portletModes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SupportsDescriptor [");
        sb.append("mime type [").append(this.mimeType).append("] ");
        sb.append("portlet mode [");
        for (int i = 0; i < this.portletModes.size(); ++i) {
            sb.append(this.portletModes.get(i));
            sb.append(", ");
        }
        sb.append("] ]");
        return sb.toString();
    }
}

