/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.viewer;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.viewer.model.DocumentView;
import org.silverpeas.core.viewer.service.ViewService;
import org.silverpeas.core.viewer.service.ViewerException;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.viewer.AbstractViewResource;
import org.silverpeas.core.webapi.viewer.DocumentViewEntity;
import org.silverpeas.core.webapi.viewer.ResourceView;

@WebService
@Path(value="view")
@Authenticated
public class DocumentViewResource
extends AbstractViewResource {
    static final String PATH = "view";
    @Inject
    private ViewService viewService;

    @GET
    @Path(value="{type}/{id}")
    @Produces(value={"application/json"})
    public DocumentViewEntity getDocumentView(@PathParam(value="id") String id, @PathParam(value="type") String type, @QueryParam(value="lang") String language) {
        try {
            ResourceView resource = this.getAuthorizedResourceView(id, type, language);
            return this.asWebEntity(this.viewService.getDocumentView(resource.getViewerContext()));
        }
        catch (ViewerException pe) {
            throw new WebApplicationException((Throwable)pe, Response.Status.NOT_FOUND);
        }
    }

    protected DocumentViewEntity asWebEntity(DocumentView documentView) {
        return (DocumentViewEntity)DocumentViewEntity.createFrom(documentView).withURI(this.getUri().getRequestUri());
    }

    protected String getResourceBasePath() {
        return PATH;
    }
}

