/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.subscribe;

import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.comment.CommentRuntimeException;
import org.silverpeas.core.contribution.publication.subscription.OnLocationDirective;
import org.silverpeas.core.subscription.SubscriberDirective;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.service.SubscribeRuntimeException;
import org.silverpeas.core.subscription.service.UserSubscriptionSubscriber;
import org.silverpeas.core.subscription.util.SubscriptionList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.subscribe.AbstractSubscriptionResource;
import org.silverpeas.core.webapi.subscribe.SubscriberEntity;
import org.silverpeas.core.webapi.subscribe.SubscriptionEntity;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="subscriptions/{componentId}")
@Authorized
public class SubscriptionResource
extends AbstractSubscriptionResource {
    @GET
    @Produces(value={"application/json"})
    public Collection<SubscriptionEntity> getComponentSubscriptions(@QueryParam(value="userId") String userId) {
        return this.getSubscriptions(CommonSubscriptionResourceConstants.COMPONENT, null, userId);
    }

    @GET
    @Path(value="{subscriptionType}/{id}")
    @Produces(value={"application/json"})
    public Collection<SubscriptionEntity> getSubscriptions(@PathParam(value="subscriptionType") String subscriptionType, @PathParam(value="id") String resourceId, @QueryParam(value="userId") String userId) {
        return this.getSubscriptions(this.decodeSubscriptionResourceType(subscriptionType), resourceId, userId);
    }

    private Collection<SubscriptionEntity> getSubscriptions(SubscriptionResourceType subscriptionResourceType, String resourceId, String userId) {
        try {
            SubscriptionList subscriptions;
            org.silverpeas.core.subscription.SubscriptionResource resource = this.getSubscriptionResource(subscriptionResourceType, resourceId);
            if (StringUtil.isDefined((String)userId)) {
                User user = "me".equals(userId) ? this.getUser() : User.getById((String)userId);
                UserSubscriptionSubscriber subscriber = UserSubscriptionSubscriber.from((String)user.getId());
                subscriptions = SubscriptionServiceProvider.getSubscribeService().getBySubscriberAndResource((SubscriptionSubscriber)subscriber, resource);
            } else {
                subscriptions = SubscriptionServiceProvider.getSubscribeService().getByResource(resource);
            }
            return this.asWebEntities((Collection<Subscription>)subscriptions.filterOnDomainVisibilityFrom(UserDetail.from((User)this.getUser())));
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="subscribers")
    @Produces(value={"application/json"})
    public Collection<SubscriberEntity> getComponentSubscribers() {
        return this.getSubscribers(CommonSubscriptionResourceConstants.COMPONENT, null);
    }

    @GET
    @Path(value="{subscriptionType}/subscribers/{id}")
    public Response getSubscribers(@PathParam(value="subscriptionType") String subscriptionType, @PathParam(value="id") String resourceId) {
        return Response.ok(this.getSubscribers(this.decodeSubscriptionResourceType(subscriptionType), resourceId), (String)"application/json").build();
    }

    private Collection<SubscriberEntity> getSubscribers(SubscriptionResourceType subscriptionResourceType, String resourceId) {
        try {
            org.silverpeas.core.subscription.SubscriptionResource subscriptionResource = this.getSubscriptionResource(subscriptionResourceType, resourceId);
            return this.asSubscriberWebEntities((Collection<SubscriptionSubscriber>)SubscriptionServiceProvider.getSubscribeService().getSubscribers(subscriptionResource).filterOnDomainVisibilityFrom(UserDetail.from((User)this.getUser())));
        }
        catch (SubscribeRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="{subscriptionType}/subscribers/inheritance")
    public Response getComponentSubscribersWithInheritance(@PathParam(value="subscriptionType") String subscriptionType, @QueryParam(value="existenceIndicatorOnly") boolean existenceIndicatorOnly) {
        return this.getSubscribersWithInheritance(subscriptionType, null, null, existenceIndicatorOnly);
    }

    @GET
    @Path(value="{subscriptionType}/subscribers/inheritance/{id}")
    public Response getSubscribersWithInheritance(@PathParam(value="subscriptionType") String subscriptionType, @PathParam(value="id") String resourceId, @QueryParam(value="locationId") String locationId, @QueryParam(value="existenceIndicatorOnly") boolean existenceIndicatorOnly) {
        try {
            SubscriberDirective[] subscriberDirectiveArray;
            SubscriptionResourceType parsedSubscriptionResourceType = this.decodeSubscriptionResourceType(subscriptionType);
            if (parsedSubscriptionResourceType == CommonSubscriptionResourceConstants.UNKNOWN) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (parsedSubscriptionResourceType != CommonSubscriptionResourceConstants.COMPONENT && StringUtil.isNotDefined((String)resourceId)) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (StringUtil.isDefined((String)locationId)) {
                SubscriberDirective[] subscriberDirectiveArray2 = new SubscriberDirective[1];
                subscriberDirectiveArray = subscriberDirectiveArray2;
                subscriberDirectiveArray2[0] = OnLocationDirective.onLocationId((String)locationId);
            } else {
                subscriberDirectiveArray = new SubscriberDirective[]{};
            }
            SubscriberDirective[] directives = subscriberDirectiveArray;
            SubscriptionSubscriberList subscribers = ResourceSubscriptionProvider.getSubscribersOfComponentAndTypedResource((String)this.getComponentId(), (SubscriptionResourceType)parsedSubscriptionResourceType, (String)resourceId, (SubscriberDirective[])directives);
            if (existenceIndicatorOnly) {
                return Response.ok((Object)String.valueOf(!subscribers.getAllUserIds().isEmpty()), (String)"application/json").build();
            }
            return Response.ok(this.asSubscriberWebEntities((Collection<SubscriptionSubscriber>)subscribers), (String)"application/json").build();
        }
        catch (SubscribeRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    protected Collection<SubscriptionEntity> asWebEntities(Collection<Subscription> subscriptions) {
        ArrayList<SubscriptionEntity> entities = new ArrayList<SubscriptionEntity>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            entities.add(this.asWebEntity(subscription));
        }
        return entities;
    }

    protected SubscriptionEntity asWebEntity(Subscription subscription) {
        return SubscriptionEntity.from(subscription);
    }

    protected Collection<SubscriberEntity> asSubscriberWebEntities(Collection<SubscriptionSubscriber> subscribers) {
        ArrayList<SubscriberEntity> entities = new ArrayList<SubscriberEntity>(subscribers.size());
        for (SubscriptionSubscriber subscriber : subscribers) {
            entities.add(this.asSubscriberWebEntity(subscriber));
        }
        return entities;
    }

    protected SubscriberEntity asSubscriberWebEntity(SubscriptionSubscriber subscriber) {
        return SubscriberEntity.from(subscriber);
    }

    protected String getResourceBasePath() {
        return "subscriptions";
    }
}

