/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.rating;

import java.net.URI;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.rating.model.Rateable;
import org.silverpeas.core.contribution.rating.model.RaterRating;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.web.SilverpeasWebResource;
import org.silverpeas.core.web.rs.WebEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RaterRatingEntity
implements WebEntity {
    private static final long serialVersionUID = 1528651545753548217L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(required=true)
    @NotNull
    @Size(min=2)
    private @NotNull @Size(min=2) String componentId;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String contributionType;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String contributionId;
    @XmlElement(required=true)
    @NotNull
    private int numberOfRaterRatings;
    @XmlElement(required=true)
    @NotNull
    private float ratingAverage;
    @XmlElement
    private int raterRatingValue;
    @XmlElement(name="isRatingDone")
    private boolean isRatingDone;

    public static RaterRatingEntity fromRateable(Rateable rateableContribution) {
        RaterRating raterRating = rateableContribution.getRating().getRaterRating(UserDetail.getCurrentRequester());
        return RaterRatingEntity.fromRaterRating(raterRating);
    }

    protected static RaterRatingEntity fromRaterRating(RaterRating raterRating) {
        return new RaterRatingEntity(raterRating).withURI(RaterRatingEntity.buildRaterRatingURI(raterRating));
    }

    private RaterRatingEntity withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getContributionType() {
        return this.contributionType;
    }

    public String getContributionId() {
        return this.contributionId;
    }

    public int getNumberOfRaterRatings() {
        return this.numberOfRaterRatings;
    }

    public float getRatingAverage() {
        return this.ratingAverage;
    }

    public int getRaterRatingValue() {
        return this.raterRatingValue;
    }

    public boolean isRatingDone() {
        return this.isRatingDone;
    }

    private RaterRatingEntity(RaterRating raterRating) {
        this.componentId = raterRating.getRating().getInstanceId();
        this.ratingAverage = raterRating.getRating().getRatingAverage();
        this.numberOfRaterRatings = raterRating.getRating().getRaterRatings().size();
        this.contributionId = raterRating.getRating().getContributionId();
        this.contributionType = raterRating.getRating().getContributionType();
        this.raterRatingValue = raterRating.getValue();
        this.isRatingDone = raterRating.isRatingDone();
    }

    public String toJSonScript(String jsVariableName) {
        return new script().setType("text/javascript").addElement("var " + jsVariableName + " = " + this.getAsJSonString() + ";").toString();
    }

    public String getAsJSonString() {
        return JSONCodec.encode((Object)this);
    }

    private static URI buildRaterRatingURI(RaterRating raterRating) {
        if (raterRating == null) {
            return null;
        }
        return SilverpeasWebResource.getBasePathBuilder().path("rating").path(raterRating.getRating().getInstanceId()).path(raterRating.getRating().getContributionType()).path(raterRating.getRating().getContributionId()).build(new Object[0]);
    }

    protected RaterRatingEntity() {
    }

    protected void setUri(URI uri) {
        this.withURI(uri);
    }

    protected void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    protected void setContributionType(String contributionType) {
        this.contributionType = contributionType;
    }

    protected void setContributionId(String contributionId) {
        this.contributionId = contributionId;
    }

    protected void setNumberOfRaterRatings(int numberOfRaterRatings) {
        this.numberOfRaterRatings = numberOfRaterRatings;
    }

    protected void setRatingAverage(float ratingAverage) {
        this.ratingAverage = ratingAverage;
    }

    protected void setRaterRatingValue(int raterRatingValue) {
        this.raterRatingValue = raterRatingValue;
    }

    protected void setRatingDone(boolean isRatingDone) {
        this.isRatingDone = isRatingDone;
    }
}

