/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.pdc.pdc.model.Axis;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.pdc.pdc.model.Value;
import org.silverpeas.core.pdc.thesaurus.model.ThesaurusException;
import org.silverpeas.core.webapi.pdc.PdcAxisValueEntity;
import org.silverpeas.core.webapi.pdc.UserThesaurusHolder;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
public class PdcAxis {
    public static final int PRIMARY_AXIS = 0;
    public static final int SECONDARY_AXIS = 1;
    @XmlElement(required=true)
    private int id;
    @XmlElement
    private boolean mandatory = false;
    @XmlElement(required=true)
    private String name;
    @XmlElement(required=true)
    private String originValue;
    @XmlElement(defaultValue="")
    private String invariantValue;
    @XmlElement
    private boolean invariant = false;
    @XmlElement(defaultValue="0")
    private int type = 0;
    @XmlElement(required=true)
    private List<PdcAxisValueEntity> values = new ArrayList<PdcAxisValueEntity>();

    public static PdcAxis fromTheUsedAxis(UsedAxis axis, String inLanguage, UserThesaurusHolder withThesaurus) throws ThesaurusException {
        String andOriginValue = axis._getBaseValuePath() + axis.getBaseValue() + "/";
        int axisType = "P".equals(axis._getAxisType()) ? 0 : 1;
        List<PdcAxisValueEntity> theAxisValues = PdcAxis.fromValues(axis._getAxisValues(), andOriginValue, inLanguage, withThesaurus);
        PdcAxis pdcAxis = new PdcAxis(axis.getAxisId(), axis._getAxisName(inLanguage)).ofType(axisType).withAsPdcAxisValues(theAxisValues, andOriginValue).withInvariance(axis.getVariant() == 0).withObligation(axis.getMandatory() == 1);
        if (StringUtil.isDefined((String)axis._getInvariantValue())) {
            pdcAxis.setInvariantValue(axis._getInvariantValue());
        }
        return pdcAxis;
    }

    public static PdcAxis fromTheAxis(Axis axis, String inLanguage, UserThesaurusHolder withThesaurus) throws ThesaurusException {
        String andOriginValue = "/0/";
        int axisType = "P".equals(axis.getAxisHeader().getAxisType()) ? 0 : 1;
        List<PdcAxisValueEntity> theAxisValues = PdcAxis.fromValues(axis.getValues(), andOriginValue, inLanguage, withThesaurus);
        PdcAxis pdcAxis = new PdcAxis(axis.getAxisHeader().getPK().getId(), axis.getAxisHeader().getName(inLanguage)).ofType(axisType).withAsPdcAxisValues(theAxisValues, andOriginValue);
        return pdcAxis;
    }

    public int getId() {
        return this.id;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isInvariant() {
        return this.invariant;
    }

    public String getName() {
        return this.name;
    }

    public String getInvariantValue() {
        return this.invariantValue;
    }

    public String getOriginValue() {
        return this.originValue;
    }

    public int getType() {
        return this.type;
    }

    public List<PdcAxisValueEntity> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public PdcAxis withAsPdcAxisValues(List<PdcAxisValueEntity> values, String originValueId) {
        this.originValue = originValueId;
        this.values.addAll(values);
        return this;
    }

    public PdcAxis ofType(int axisType) {
        this.type = axisType;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdcAxis other = (PdcAxis)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.mandatory != other.mandatory) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.originValue == null ? other.originValue != null : !this.originValue.equals(other.originValue)) {
            return false;
        }
        if (this.invariantValue == null ? other.invariantValue != null : !this.invariantValue.equals(other.invariantValue)) {
            return false;
        }
        return this.values == other.values || this.values != null && this.values.equals(other.values);
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + this.id;
        hash = 53 * hash + (this.mandatory ? 1 : 0);
        hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 53 * hash + (this.originValue != null ? this.originValue.hashCode() : 0);
        hash = 53 * hash + (this.invariantValue != null ? this.invariantValue.hashCode() : 0);
        hash = 53 * hash + (this.values != null ? this.values.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder axisValuesArray = new StringBuilder("[");
        for (PdcAxisValueEntity value : this.getValues()) {
            axisValuesArray.append(value.toString()).append(", ");
        }
        if (axisValuesArray.length() > 1) {
            axisValuesArray.replace(axisValuesArray.length() - 2, axisValuesArray.length(), "]");
        } else {
            axisValuesArray.append("]");
        }
        return "PdcAxis{id=" + this.getId() + ", name=" + this.getName() + ", mandatory=" + this.isMandatory() + ", originValue=" + this.getOriginValue() + ", invariantValue=" + this.getInvariantValue() + ", values=" + axisValuesArray.toString() + "}";
    }

    private static List<PdcAxisValueEntity> fromValues(List<Value> values, String originValueId, String inLanguage, UserThesaurusHolder usingThesaurus) throws ThesaurusException {
        ArrayList<PdcAxisValueEntity> axisValues = new ArrayList<PdcAxisValueEntity>();
        for (Value value : values) {
            PdcAxisValueEntity axisValue = PdcAxisValueEntity.fromValue(value, inLanguage);
            if (PdcAxis.isFather(axisValue.getId(), originValueId)) {
                axisValue.setAsAscendant();
                if (axisValue.getId().equals(originValueId)) {
                    axisValue.setAsOriginValue();
                }
            } else if (!PdcAxis.isChild(axisValue.getId(), originValueId)) continue;
            if (usingThesaurus != null) {
                axisValues.add(PdcAxis.withSynonym(axisValue, usingThesaurus));
                continue;
            }
            axisValues.add(axisValue);
        }
        return axisValues;
    }

    private static PdcAxisValueEntity withSynonym(PdcAxisValueEntity axisValue, UserThesaurusHolder thesaurus) throws ThesaurusException {
        axisValue.setSynonyms(thesaurus.getSynonymsOf(axisValue));
        return axisValue;
    }

    private static boolean isChild(String path, String anotherPath) {
        return path.startsWith(anotherPath);
    }

    private static boolean isFather(String path, String anotherPath) {
        return anotherPath.startsWith(path);
    }

    private PdcAxis() {
    }

    private PdcAxis(int axisId, String axisName) {
        this.id = axisId;
        this.name = axisName;
    }

    private PdcAxis(String axisId, String axisName) {
        this.id = Integer.valueOf(axisId);
        this.name = axisName;
    }

    private PdcAxis withObligation(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    private PdcAxis withInvariance(boolean invariant) {
        this.invariant = invariant;
        return this;
    }

    private void setInvariantValue(String invariantValueId) {
        this.invariantValue = invariantValueId;
    }
}

