/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.notification.user;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import java.util.Date;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILMessage;
import org.silverpeas.core.security.html.HtmlSanitizer;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.kernel.logging.SilverLogger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InboxUserNotificationEntity
implements WebEntity {
    private static final long serialVersionUID = 4872081532099078450L;
    private URI uri;
    private URI markAsReadUri;
    private long id;
    private String source;
    private String subject;
    private String senderName;
    private String date;
    private URI resourceViewUrl;
    private String content;
    private boolean read;

    protected InboxUserNotificationEntity() {
    }

    public static InboxUserNotificationEntity from(SILVERMAILMessage notification) {
        return new InboxUserNotificationEntity().decorate(notification);
    }

    public InboxUserNotificationEntity withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    public InboxUserNotificationEntity withMarkAsReadURI(URI uri) {
        this.markAsReadUri = uri;
        return this;
    }

    @XmlElement
    public URI getURI() {
        return this.uri;
    }

    @XmlElement
    public URI getMarkAsReadURI() {
        return this.markAsReadUri;
    }

    @XmlElement
    public long getId() {
        return this.id;
    }

    @XmlElement
    public String getSource() {
        return this.source;
    }

    @XmlElement
    public String getSubject() {
        return this.subject;
    }

    @XmlElement
    public String getSenderName() {
        return this.senderName;
    }

    @XmlElement
    public String getDate() {
        return this.date;
    }

    @XmlElement
    public URI getResourceViewUrl() {
        return this.resourceViewUrl;
    }

    @XmlElement
    public String getContent() {
        return this.content;
    }

    @XmlElement
    public boolean isRead() {
        return this.read;
    }

    protected InboxUserNotificationEntity decorate(SILVERMAILMessage notification) {
        this.id = notification.getId();
        this.source = notification.getSource();
        HtmlSanitizer htmlSanitizer = HtmlSanitizer.get();
        this.subject = htmlSanitizer.sanitize(notification.getSubject());
        this.senderName = notification.getSenderName();
        this.date = DateUtil.toLocalDate((Date)notification.getDate()).toString();
        try {
            this.resourceViewUrl = UriBuilder.fromUri((String)notification.getUrl()).build(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
        this.content = htmlSanitizer.sanitize(notification.getBody());
        this.read = notification.getReaden() > 0;
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("uri", (Object)this.getURI());
        builder.append("id", this.getId());
        builder.append("source", (Object)this.getSource());
        builder.append("subject", (Object)this.getSubject());
        builder.append("senderName", (Object)this.getSenderName());
        builder.append("date", (Object)this.getDate());
        builder.append("resourceViewUrl", (Object)this.getResourceViewUrl());
        builder.append("content", (Object)this.getContent());
        builder.append("read", this.isRead());
        return builder.toString();
    }
}

