/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.mylinks;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.mylinks.model.CategoryDetail;
import org.silverpeas.core.mylinks.model.LinkDetail;
import org.silverpeas.core.mylinks.service.MyLinksService;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.mvc.webcomponent.WebMessager;
import org.silverpeas.core.webapi.mylinks.CategoryEntity;
import org.silverpeas.core.webapi.mylinks.MyLinkEntity;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class MyLinksWebManager {
    @Inject
    private MyLinksService service;

    protected MyLinksWebManager() {
    }

    public static MyLinksWebManager get() {
        return (MyLinksWebManager)ServiceProvider.getService(MyLinksWebManager.class, (Annotation[])new Annotation[0]);
    }

    public List<CategoryDetail> getAllCategoriesOfCurrentUser() {
        User currentRequester = User.getCurrentRequester();
        if (currentRequester != null) {
            return this.service.getAllCategoriesByUser(currentRequester.getId());
        }
        return Collections.emptyList();
    }

    public CategoryDetail getAuthorizedCategory(String categoryId) {
        if (StringUtil.isNotDefined((String)categoryId)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        CategoryDetail category = this.service.getCategory(categoryId);
        if (category == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!category.canBeModifiedBy(User.getCurrentRequester())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return category;
    }

    public CategoryDetail createCategory(CategoryEntity newCategory) {
        this.checkMandatoryCategoryData(newCategory);
        User currentRequester = User.getCurrentRequester();
        CategoryDetail category = newCategory.toCategoryDetail();
        category.setUserId(currentRequester.getId());
        if (!category.canBeModifiedBy(currentRequester)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return this.service.createCategory(category);
    }

    public CategoryDetail updateCategory(CategoryEntity updatedCategory) {
        this.getAuthorizedCategory(String.valueOf(updatedCategory.getCategoryId()));
        this.checkMandatoryCategoryData(updatedCategory);
        CategoryDetail category = updatedCategory.toCategoryDetail();
        category.setUserId(User.getCurrentRequester().getId());
        return this.service.updateCategory(category);
    }

    public void deleteCategories(String[] categoryIds) {
        if (categoryIds.length > 0) {
            for (String categoryId : categoryIds) {
                this.getAuthorizedCategory(categoryId);
            }
            this.service.deleteCategories(categoryIds);
            this.getMessager().addSuccess(this.getBundle().getString("myLinks.deleteCategories.messageConfirm"), categoryIds.length);
        }
    }

    public List<LinkDetail> getAllLinksOfInstance(String instanceId) {
        return this.service.getAllLinksByInstance(instanceId);
    }

    public List<LinkDetail> getAllLinksOfResourceOnInstance(String resourceId, String instanceId) {
        return this.service.getAllLinksByObject(instanceId, resourceId);
    }

    public List<LinkDetail> getAllLinksOfCurrentUser() {
        User currentRequester = User.getCurrentRequester();
        if (currentRequester != null) {
            return this.service.getAllLinksByUser(currentRequester.getId());
        }
        return Collections.emptyList();
    }

    public LinkDetail getAuthorizedLink(String linkId) {
        if (StringUtil.isNotDefined((String)linkId)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        LinkDetail link = this.service.getLink(linkId);
        if (link == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!link.canBeModifiedBy(User.getCurrentRequester())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return link;
    }

    public LinkDetail createLink(MyLinkEntity newLink) {
        this.checkMandatoryLinkData(newLink);
        LinkDetail linkDetail = newLink.toLinkDetail();
        User currentRequester = User.getCurrentRequester();
        linkDetail.setUserId(currentRequester.getId());
        if (!linkDetail.canBeModifiedBy(currentRequester)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        linkDetail = this.service.createLink(linkDetail);
        return linkDetail;
    }

    public LinkDetail updateLink(MyLinkEntity updatedLink) {
        this.getAuthorizedLink(String.valueOf(updatedLink.getLinkId()));
        this.checkMandatoryLinkData(updatedLink);
        LinkDetail linkDetail = updatedLink.toLinkDetail();
        linkDetail.setUserId(User.getCurrentRequester().getId());
        linkDetail = this.service.updateLink(linkDetail);
        return linkDetail;
    }

    public void deleteLinks(String[] links) {
        if (links.length > 0) {
            for (String linkId : links) {
                this.getAuthorizedLink(linkId);
            }
            this.service.deleteLinks(links);
            this.getMessager().addSuccess(this.getBundle().getString("myLinks.deleteLinks.messageConfirm"), links.length);
        }
    }

    private void checkMandatoryCategoryData(CategoryEntity category) {
        if (!StringUtil.isDefined((String)category.getName())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    private void checkMandatoryLinkData(MyLinkEntity myLink) {
        if (!StringUtil.isDefined((String)myLink.getUrl()) || !StringUtil.isDefined((String)myLink.getName())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    private LocalizationBundle getBundle() {
        User owner = User.getCurrentRequester();
        String userLanguage = owner.getUserPreferences().getLanguage();
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.mylinks.multilang.myLinksBundle", (String)userLanguage);
    }

    private WebMessager getMessager() {
        return WebMessager.getInstance();
    }
}

