/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.media.streaming;

import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.plugins.providers.html.View;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.io.media.Definition;
import org.silverpeas.core.web.http.RequestParameterDecoder;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.webapi.media.streaming.EmbedStreamingPlayerParams;
import org.silverpeas.core.webapi.media.streaming.StreamingProviderDataEntity;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="media/streaming")
public class StreamingPlayerResource
extends RESTWebService {
    static final String PATH = "media/streaming";

    protected String getResourceBasePath() {
        return PATH;
    }

    @GET
    @Path(value="providerData")
    @Produces(value={"application/json"})
    public StreamingProviderDataEntity getStreamingProviderDataFromUrl() {
        EmbedStreamingPlayerParams params = (EmbedStreamingPlayerParams)RequestParameterDecoder.decode((ServletRequest)this.getHttpServletRequest(), EmbedStreamingPlayerParams.class);
        try {
            this.checkMandatoryParams(params);
            String url = params.getUrl();
            StreamingProviderDataEntity entity = this.getHandledStreamingProvider(url);
            return entity.withURI(this.getUri().getRequestUri());
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @Path(value="player")
    @GET
    public View getPlayerContent() {
        EmbedStreamingPlayerParams params = (EmbedStreamingPlayerParams)RequestParameterDecoder.decode((ServletRequest)this.getHttpServletRequest(), EmbedStreamingPlayerParams.class);
        try {
            this.checkMandatoryParams(params);
            String url = params.getUrl();
            Definition definition = params.getDefinition();
            StreamingProviderDataEntity streamingEntity = this.getHandledStreamingProvider(url);
            this.getHttpServletRequest().setAttribute("entity", (Object)streamingEntity);
            this.getHttpServletRequest().setAttribute("definition", (Object)definition);
            return new View("/media/jsp/embedStreaming.jsp");
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private StreamingProviderDataEntity getHandledStreamingProvider(String url) {
        StreamingProviderDataEntity streamingEntity = StreamingProviderDataEntity.from(url).orElseThrow(() -> new WebApplicationException(String.format("Streaming URL '%s' is not Handled", url)));
        if (this.getHttpRequest().isSecure()) {
            streamingEntity.forceSecureEmbedUrl();
        }
        return streamingEntity;
    }

    public String getComponentId() {
        return null;
    }

    private void checkMandatoryParams(EmbedStreamingPlayerParams params) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (StringUtil.isNotDefined((String)params.getUrl())) {
            errorMessages.add("url is not defined");
        }
        if (!errorMessages.isEmpty()) {
            throw new WebApplicationException(errorMessages.stream().collect(Collectors.joining(", ")), Response.Status.BAD_REQUEST);
        }
    }
}

