/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.media;

import java.net.URI;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FilenameUtils;
import org.jboss.resteasy.plugins.providers.html.View;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.io.file.SilverpeasFileProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.viewer.model.DocumentView;
import org.silverpeas.core.viewer.model.ViewerSettings;
import org.silverpeas.core.viewer.service.ViewService;
import org.silverpeas.core.web.http.FileResponse;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.viewer.ResourceView;
import org.silverpeas.core.webapi.viewer.ResourceViewProvider;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="media/viewer/embed")
@Authenticated
public class EmbedMediaViewerResource
extends RESTWebService {
    static final String PATH = "media/viewer/embed";
    private static final String PDF_VIEWER_CACHE_PREFIX = "PdfEmbedMediaViewer_";
    @Inject
    private ViewService viewService;

    protected String getResourceBasePath() {
        return PATH;
    }

    @GET
    @Path(value="pdf")
    public View getPdfEmbedViewer(@QueryParam(value="documentId") String documentId, @QueryParam(value="documentType") String documentType, @QueryParam(value="language") String language) {
        try {
            ResourceView resource = ResourceViewProvider.getAuthorizedResourceView(documentId, documentType, language);
            this.getHttpServletRequest().setAttribute("contentUrl", (Object)this.getUri().getRequestUriBuilder().path("content").build(new Object[0]));
            this.setCommonRequestViewerAttributes(resource);
            String cacheKey = PDF_VIEWER_CACHE_PREFIX + documentId + "@" + language;
            CacheAccessorProvider.getApplicationCacheAccessor().getCache().put((Object)cacheKey, (Object)true, 10, 0);
            return new View("/media/jsp/pdf/viewer.jsp");
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (AttachmentException ex) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="pdf/content")
    public Response getPdfContent(@QueryParam(value="documentId") String documentId, @QueryParam(value="documentType") String documentType, @QueryParam(value="language") String language) {
        try {
            boolean playerAccessed;
            String cacheKey = PDF_VIEWER_CACHE_PREFIX + documentId + "@" + language;
            boolean bl = playerAccessed = CacheAccessorProvider.getApplicationCacheAccessor().getCache().remove((Object)cacheKey) != null;
            if (!playerAccessed) {
                return Response.seeOther((URI)this.getUri().getAbsoluteWebResourcePathBuilder().path("pdf").queryParam("documentId", new Object[]{documentId}).queryParam("documentType", new Object[]{documentType}).queryParam("language", new Object[]{language}).build(new Object[0])).build();
            }
            ResourceView resource = ResourceViewProvider.getAuthorizedResourceView(documentId, documentType, language);
            DocumentView view = this.viewService.getDocumentView(resource.getViewerContext());
            return this.sendView(resource, view);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (AttachmentException ex) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="fp")
    public View getFlowPaperEmbedViewer(@QueryParam(value="documentId") String documentId, @QueryParam(value="documentType") String documentType, @QueryParam(value="language") String language) {
        try {
            ResourceView resource = ResourceViewProvider.getAuthorizedResourceView(documentId, documentType, language);
            DocumentView view = this.viewService.getDocumentView(resource.getViewerContext());
            String displayLicenseKey = view.getDisplayLicenseKey();
            Object displayViewerPath = StringUtil.isDefined((String)displayLicenseKey) ? UriBuilder.fromPath((String)"/weblib").path("flexpaper").path("flash").build(new Object[0]).toString() : URLUtil.getApplicationURL() + "/media/jsp/fp/core/flash";
            this.getHttpServletRequest().setAttribute("contentUrl", (Object)this.getUri().getBaseUriBuilder().path(PATH).path("fp/content").path(documentId).path(language).path(view.getPhysicalFile().getName()).build(new Object[0]));
            this.setCommonRequestViewerAttributes(resource);
            this.getHttpServletRequest().setAttribute("documentView", (Object)view);
            this.getHttpServletRequest().setAttribute("displayViewerPath", displayViewerPath);
            return new View("/media/jsp/fp/viewer.jsp");
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (AttachmentException ex) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="fp/content/{documentId}/{language}/{page}")
    public Response getFlowPaperContent(@PathParam(value="documentId") String documentId, @QueryParam(value="documentType") String documentType, @PathParam(value="language") String language, @PathParam(value="page") String page) {
        try {
            ResourceView resource = ResourceViewProvider.getAuthorizedResourceView(documentId, documentType, language);
            DocumentView view = this.viewService.getDocumentView(resource.getViewerContext());
            if (view.getServerFilePath().toString().endsWith("file.pdf")) {
                return Response.seeOther((URI)this.getUri().getAbsoluteWebResourcePathBuilder().path("pdf").queryParam("documentId", new Object[]{documentId}).queryParam("documentType", new Object[]{documentType}).queryParam("language", new Object[]{language}).build(new Object[0])).build();
            }
            return this.sendView(resource, view, page);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (AttachmentException ex) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    public String getComponentId() {
        return null;
    }

    private void setCommonRequestViewerAttributes(ResourceView resource) {
        this.getHttpServletRequest().setAttribute("downloadEnabled", (Object)resource.isDownloadableBy(this.getUser()));
        this.getHttpServletRequest().setAttribute("editionToolsEnabled", (Object)ViewerSettings.pdfViewerEditionToolsEnabled());
        this.getHttpServletRequest().setAttribute("userLanguage", (Object)this.getUserPreferences().getLanguage());
    }

    private Response sendView(ResourceView resource, DocumentView view) {
        return this.sendView(resource, view, null);
    }

    private Response sendView(ResourceView resource, DocumentView view, String page) {
        java.nio.file.Path path = StringUtil.isDefined((String)page) ? Paths.get(view.getServerFilePath().getParent().toString(), page) : view.getServerFilePath();
        SilverpeasFile file = SilverpeasFileProvider.getFile((String)path.toString());
        String filename = StringUtil.isDefined((String)page) ? view.getOriginalFileName() : FilenameUtils.getBaseName((String)view.getOriginalFileName()) + ".pdf";
        return FileResponse.fromRest((HttpServletRequest)this.getHttpRequest(), this.getHttpServletResponse()).forceMimeType(resource.getContentType()).forceFileName(filename).silverpeasFile(file).build();
    }
}

