/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.look;

import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.UriInfo;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public final class LookResourceURIs {
    public static final String DISPLAY_BASE_URI = "display";
    public static final String DISPLAY_USER_CONTEXT_URI_PART = "userContext";
    private static final char separator = '/';

    protected static URI buildURI(UriInfo uriInfo, String ... uriPathParts) {
        return LookResourceURIs.buildURI(uriInfo.getBaseUri().toString(), uriPathParts);
    }

    protected static URI buildURI(String uriBase, String ... uriPathParts) {
        try {
            return new URI(LookResourceURIs.buildStringURI(uriBase, uriPathParts));
        }
        catch (URISyntaxException ex) {
            SilverLogger.getLogger(LookResourceURIs.class).error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static String buildStringURI(String uriBase, String ... uriPathParts) {
        if (!StringUtil.isDefined((String)uriBase)) {
            return "";
        }
        StringBuilder stringURI = new StringBuilder(uriBase);
        if (uriPathParts != null) {
            for (String pathPart : uriPathParts) {
                if (stringURI.charAt(stringURI.length() - 1) != '/') {
                    stringURI.append('/');
                }
                stringURI.append(pathPart);
            }
        }
        return stringURI.toString();
    }
}

