/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.language;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.language.LanguageEntity;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

@WebService
@Path(value="languages")
@Authenticated
public class LanguageResource
extends RESTWebService {
    private static final String MY_PROFILE_SETTINGS_LANGUAGE_KEY = "myProfile.settings.language_";
    static final String PATH = "languages";

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    public List<LanguageEntity> getAvailableLanguages() {
        ArrayList<LanguageEntity> languages = new ArrayList<LanguageEntity>();
        LocalizationBundle multilang = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.social.multilang.socialNetworkBundle", (String)this.getUserPreferences().getLanguage());
        for (String language : DisplayI18NHelper.getLanguages()) {
            LanguageEntity entity = new LanguageEntity(language, multilang.getString(MY_PROFILE_SETTINGS_LANGUAGE_KEY + language));
            entity.setURI(this.getUri().getRequestUriBuilder().path(language).build(new Object[0]));
            languages.add(entity);
        }
        return languages;
    }
}

