/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.contribution;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FieldValuesTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.contribution.AbstractContributionResource;
import org.silverpeas.core.webapi.contribution.FormEntity;
import org.silverpeas.core.webapi.contribution.FormFieldEntity;
import org.silverpeas.core.webapi.contribution.FormFieldValueEntity;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="contribution/{componentInstanceId}/{contributionId}/content")
@Authorized
public class ContributionContentResource
extends AbstractContributionResource {
    private static final String CONTRIBUTION_BASE_URI = "contribution";
    private static final String CONTRIBUTION_CONTENT_URI_PART = "content";
    private static final String CONTRIBUTION_CONTENT_FORM_URI_PART = "form";
    @PathParam(value="componentInstanceId")
    private String componentInstanceId;
    @PathParam(value="contributionId")
    private String contributionId;

    protected String getResourceBasePath() {
        return CONTRIBUTION_BASE_URI;
    }

    public String getComponentId() {
        return this.componentInstanceId;
    }

    @Override
    public String getContributionId() {
        return this.contributionId;
    }

    @GET
    @Path(value="form")
    @Produces(value={"application/json"})
    public FormEntity getFormContent(@QueryParam(value="lang") String lang) {
        return this.getFormContent(this.getDefaultFormId(), lang, false);
    }

    @GET
    @Path(value="form/{formId}")
    @Produces(value={"application/json"})
    public FormEntity getFormContent(@PathParam(value="formId") String formId, @QueryParam(value="lang") String lang, @QueryParam(value="renderView") boolean renderView) {
        try {
            String language = StringUtil.isDefined((String)lang) ? lang : this.getDefaultPublicationTemplateLanguage();
            FormData formData = this.loadFormData(formId, language, renderView);
            DataRecord data = formData.getData();
            FormEntity form = FormEntity.createFrom(formId);
            for (FieldTemplate fieldTemplate : formData.getRecordTemplate().getFieldTemplates()) {
                FormFieldEntity fieldEntity;
                FieldValuesTemplate fieldValuesTemplate = fieldTemplate.getFieldValuesTemplate(language);
                if (fieldTemplate.isRepeatable() || !fieldValuesTemplate.isEmpty()) {
                    List<FormFieldValueEntity> fieldValueEntities = this.getFormFieldValues(fieldTemplate, data, language);
                    fieldEntity = FormFieldEntity.createFrom(fieldTemplate.getTypeName(), fieldTemplate.getFieldName(), fieldTemplate.getLabel(language), fieldValueEntities);
                    form.addFormField(fieldEntity);
                    continue;
                }
                FormFieldValueEntity fieldValueEntity = this.getFormFieldValue(fieldTemplate, data, language);
                fieldEntity = FormFieldEntity.createFrom(fieldTemplate.getTypeName(), fieldTemplate.getFieldName(), fieldTemplate.getLabel(language), fieldValueEntity);
                form.addFormField(fieldEntity);
            }
            formData.getFormView().ifPresent(v -> {
                PagesContext context = new PagesContext("myForm", "0", this.getUserPreferences().getLanguage(), false, this.getComponentId(), this.getUser().getId());
                context.setObjectId(this.contributionId);
                form.withRenderedView(v.toString(context, data));
            });
            URI formUri = this.getUri().getBaseUriBuilder().segment(new String[]{CONTRIBUTION_BASE_URI, this.getComponentId(), this.getContributionId(), CONTRIBUTION_CONTENT_URI_PART, CONTRIBUTION_CONTENT_FORM_URI_PART, formId}).build(new Object[0]);
            return (FormEntity)form.withURI(formUri);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private FormData loadFormData(String formId, String language, boolean renderView) throws PublicationTemplateException, FormException {
        PublicationTemplate publicationTemplate;
        FormData formData = new FormData();
        if (StringUtil.isDefined((String)formId) && (publicationTemplate = this.getPublicationTemplate(formId)) != null) {
            if (renderView) {
                formData.setFormView(publicationTemplate.getViewForm());
            }
            formData.setRecordTemplate(publicationTemplate.getRecordTemplate());
            formData.setData(publicationTemplate.getRecordSet().getRecord(this.contributionId, language));
        }
        if (formData.getRecordTemplate() == null || formData.getData() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return formData;
    }

    private static class FormData {
        private RecordTemplate recordTemplate = null;
        private DataRecord data = null;
        private Form formView = null;

        private FormData() {
        }

        public RecordTemplate getRecordTemplate() {
            return this.recordTemplate;
        }

        public void setRecordTemplate(RecordTemplate recordTemplate) {
            this.recordTemplate = recordTemplate;
        }

        public DataRecord getData() {
            return this.data;
        }

        public void setData(DataRecord data) {
            this.data = data;
        }

        public Optional<Form> getFormView() {
            return Optional.ofNullable(this.formView);
        }

        public void setFormView(Form formView) {
            this.formView = formView;
        }
    }
}

