/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.attachment;

import java.util.Optional;
import javax.inject.Inject;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.viewer.service.ViewerContext;
import org.silverpeas.core.webapi.viewer.ResourceView;
import org.silverpeas.core.webapi.viewer.ResourceViewProvider;
import org.silverpeas.core.webapi.viewer.ResourceViewProviderRegistry;

public class SimpleDocumentEmbedMediaViewProvider
implements ResourceViewProvider,
Initialization {
    @Inject
    private AttachmentService service;

    public void init() {
        ResourceViewProviderRegistry.get().addNewEmbedMediaProvider(this);
    }

    @Override
    public Optional<ResourceView> getByIdAndLanguage(String documentId, String language) {
        return Optional.ofNullable(this.service.searchDocumentById(new SimpleDocumentPK(documentId), language)).map(x$0 -> new SimpleDocumentResourceView((SimpleDocument)x$0));
    }

    @Override
    public String relatedToService() {
        return "attachment";
    }

    private static class SimpleDocumentResourceView
    implements ResourceView {
        private final SimpleDocument document;

        private SimpleDocumentResourceView(SimpleDocument document) {
            this.document = document;
        }

        @Override
        public String getId() {
            return this.document.getId();
        }

        @Override
        public String getName() {
            return this.document.getFilename();
        }

        @Override
        public String getContentType() {
            return this.document.getContentType();
        }

        @Override
        public ViewerContext getViewerContext() {
            return ViewerContext.from((SimpleDocument)this.document);
        }

        public boolean canBeAccessedBy(User user) {
            return this.document.canBeAccessedBy(user);
        }

        @Override
        public boolean isDownloadableBy(User user) {
            return this.document.isDownloadAllowedForRolesFrom(user);
        }
    }
}

