/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.web.WebResourceUri;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.admin.AbstractAdminResource;
import org.silverpeas.core.webapi.admin.ComponentEntity;
import org.silverpeas.core.webapi.admin.UsersAndGroupsRoleEntity;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="components/{componentId}")
@Authorized
public class ComponentResource
extends AbstractAdminResource {
    @PathParam(value="componentId")
    private String componentId;
    @XmlTransient
    private String fullComponentId;
    @Context
    private UriInfo uriInfo;

    protected String getResourceBasePath() {
        return "components";
    }

    protected WebResourceUri initWebResourceUri() {
        return new WebResourceUri(this.getResourceBasePath(), this.getHttpServletRequest(), this.uriInfo);
    }

    @GET
    @Produces(value={"application/json"})
    public ComponentEntity get() {
        try {
            return this.asWebEntity(this.loadComponent(this.getComponentId()));
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="usersAndGroupsRoles")
    @Produces(value={"application/json"})
    public Map<SilverpeasRole, UsersAndGroupsRoleEntity> getUsersAndGroupsRoles(@QueryParam(value="roles") String roles) {
        try {
            LinkedHashMap<SilverpeasRole, UsersAndGroupsRoleEntity> result = new LinkedHashMap<SilverpeasRole, UsersAndGroupsRoleEntity>();
            List aimedRoles = new ArrayList(0);
            if (StringUtil.isDefined((String)roles)) {
                aimedRoles = CollectionUtil.asList((Object[])StringUtils.split((String)roles, (String)","));
            }
            ComponentInst componentInst = this.getOrganisationController().getComponentInst(this.getComponentId());
            ArrayList profiles = new ArrayList();
            profiles.addAll(componentInst.getInheritedProfiles());
            profiles.addAll(componentInst.getProfiles());
            LocalizationBundle resource = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.jobStartPagePeas.multilang.jobStartPagePeasBundle", (String)this.getUserPreferences().getLanguage());
            for (ProfileInst profile : profiles) {
                SilverpeasRole role = SilverpeasRole.fromString((String)profile.getName());
                if (role == null || !aimedRoles.isEmpty() && !aimedRoles.contains(role.getName())) continue;
                UsersAndGroupsRoleEntity roleEntity = (UsersAndGroupsRoleEntity)result.get(role);
                if (roleEntity == null) {
                    roleEntity = UsersAndGroupsRoleEntity.createFrom(role, resource.getString("JSPP." + role.getName()));
                    roleEntity.withURI(this.getUri().getWebResourcePathBuilder().path(this.componentId).path("usersAndGroupsRoles").queryParam("roles", new Object[]{role.getName()}).build(new Object[0])).withParentURI(this.getUri().getWebResourcePathBuilder().path(this.componentId).build(new Object[0]));
                    result.put(role, roleEntity);
                }
                for (String userId : profile.getAllUsers()) {
                    roleEntity.addUser(this.getUri().getBaseUriBuilder().path("profile/users").path(userId).build(new Object[0]));
                }
                for (String groupId : profile.getAllGroups()) {
                    roleEntity.addGroup(this.getUri().getBaseUriBuilder().path("profile/groups").path(groupId).build(new Object[0]));
                }
            }
            return result;
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    public String getComponentId() {
        if (!StringUtil.isDefined((String)this.fullComponentId)) {
            ComponentInstLight component = this.loadComponent(this.componentId);
            this.fullComponentId = component != null ? component.getId() : this.componentId;
        }
        return this.fullComponentId;
    }
}

