/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.web.util.viewgenerator.html.SimpleGraphicElement;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPane;

public class ArrayColumn
implements SimpleGraphicElement {
    public static final int COLUMN_BEHAVIOUR_NO_TRIGGER = 1;
    public static final int COLUMN_BEHAVIOUR_DEFAULT = 0;
    private String title;
    private final int columnNumber;
    private final ArrayPane pane;
    private int sortBehaviour = 0;
    private String width = null;
    private BiFunction<Object, Integer, Comparable<Object>> compareOn;
    protected String routingAddress = null;

    public ArrayColumn(String title2, int columnNumber, ArrayPane pane) {
        this.title = title2;
        this.columnNumber = columnNumber;
        this.pane = pane;
    }

    public void setRoutingAddress(String address) {
        this.routingAddress = address;
    }

    public void setSortable(boolean sortable) {
        this.sortBehaviour = sortable ? 0 : 1;
    }

    public boolean isSortable() {
        if (this.pane.getSortable()) {
            return this.sortBehaviour == 0;
        }
        return false;
    }

    public BiFunction<Object, Integer, Comparable<Object>> getCompareOn() {
        return this.compareOn;
    }

    public void setCompareOn(BiFunction<Object, Integer, Comparable<Object>> compareOn) {
        this.setSortable(true);
        this.compareOn = compareOn;
    }

    public void setTitle(String title2) {
        this.title = title2;
    }

    public String getTitle() {
        return this.title;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getWidth() {
        return this.width;
    }

    protected boolean isArrayPaneURL(String address) {
        return address != null && address.trim().toLowerCase().startsWith("arraypane:");
    }

    @Override
    public String print() {
        StringBuilder result = new StringBuilder();
        boolean isAP = false;
        result.append("<th scope=\"col\"");
        if (this.getWidth() != null) {
            result.append(" width=\"").append(this.getWidth()).append("\" ");
        }
        if (this.title != null) {
            result.append(" class=\"ArrayColumn\">");
            if (this.isSortable()) {
                this.setHeaderHref(isAP, result);
            } else {
                result.append(this.title).append("</th>");
            }
        } else {
            result.append(" class=\"ArrayColumn\">&nbsp;</th>");
        }
        return result.toString();
    }

    private void setHeaderHref(boolean isAP, StringBuilder result) {
        String address;
        String jsStartString = "";
        String jsEndString = "";
        if (this.routingAddress == null) {
            address = ((HttpServletRequest)this.pane.getRequest()).getRequestURI();
            if ((address = address.substring(address.lastIndexOf(47) + 1)).lastIndexOf(63) >= 0) {
                address = address.substring(0, address.lastIndexOf(63));
            }
        } else {
            address = this.routingAddress;
            isAP = this.isArrayPaneURL(address);
            if (isAP) {
                address = "javascript:doArrayPane";
                jsStartString = "(";
                jsEndString = ");";
            }
        }
        String sep = "&";
        StringBuilder href = new StringBuilder();
        href.append(address).append(jsStartString);
        if (!isAP) {
            String temp = result.toString();
            if (temp.indexOf(63) >= 0 || href.indexOf("?") >= 0) {
                href.append(sep);
            } else {
                href.append("?");
            }
            href.append("ArrayPaneAction").append("=Sort").append(sep);
            href.append("ArrayPaneTarget").append('=').append(this.pane.getName());
            href.append(sep).append("ArrayPaneColumn").append('=').append(this.getColumnNumber());
        } else {
            href.append("'").append(this.pane.getName()).append("',").append(this.getColumnNumber());
        }
        href.append(jsEndString);
        result.append("<a class=\"ArrayColumn\" href=\"").append((CharSequence)href);
        result.append("\">").append(this.title).append("</a>");
        result.append("</th>");
    }
}

