/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.ecs.xhtml.img;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class ImageTag
extends SimpleTagSupport {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.lookAndFeel.generalLook");
    private static final String IMAGE_SIZE_KEY_PREFIX = "image.size.";
    private String src;
    private String alt;
    private String title;
    private String type;
    private String size;
    private String css;
    private String id;

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getAlt() {
        return StringUtil.isDefined((String)this.alt) ? this.alt : "";
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title2) {
        this.title = title2;
    }

    public void doTag() throws JspException, IOException {
        this.println(this.generateHtml());
    }

    public String generateHtml() {
        Object imgSrc = StringUtil.isDefined((String)this.getSrc()) ? this.getSrc().trim() : "";
        String imgCssClass = this.getCss();
        String imgId = this.getId();
        String imgType = this.getType();
        if (!((String)imgSrc).contains("/jsp/") && !((String)imgSrc).contains("/icons/")) {
            String imageSize = this.getSize();
            if (!StringUtil.isDefined((String)imageSize) && StringUtil.isDefined((String)imgType)) {
                imageSize = settings.getString(IMAGE_SIZE_KEY_PREFIX + imgType.trim());
            }
            imgSrc = FileServerUtils.getImageURL((String)imgSrc, (String)imageSize);
        }
        if (!((String)imgSrc).startsWith(this.getWebContext())) {
            imgSrc = this.getWebContext() + (String)imgSrc;
        }
        img img2 = new img((String)imgSrc);
        img2.setAlt(this.getAlt());
        if (!StringUtil.isDefined((String)imgCssClass)) {
            if (StringUtil.isDefined((String)imgType)) {
                img2.setClass(imgType);
            }
        } else {
            img2.setClass(imgCssClass);
        }
        if (StringUtil.isDefined((String)imgId)) {
            img2.setID(imgId);
        }
        if (StringUtil.isDefined((String)this.title)) {
            img2.setTitle(this.title);
        }
        return img2.toString();
    }

    public String toString() {
        return this.generateHtml();
    }

    protected void println(String txt) throws IOException {
        this.getJspContext().getOut().println(txt);
    }

    protected String getWebContext() {
        return URLUtil.getApplicationURL();
    }
}

