/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html;

import java.io.Writer;
import java.util.Optional;
import java.util.function.Predicate;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.FieldSet;
import org.apache.ecs.html.Legend;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.web.authentication.credentials.RegistrationSettings;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.kernel.util.StringUtil;

public class DirectoryExtraFormTag
extends SimpleTagSupport {
    private String userId;
    private boolean edition = false;
    private boolean skippable = false;
    private String domainId;

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setEdition(boolean edition) {
        this.edition = edition;
    }

    public void setSkippable(boolean skippable) {
        this.skippable = skippable;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public void doTag() {
        PagesContext formContext = this.getFormContext();
        Form form2 = this.getForm(formContext);
        if (form2 != null) {
            ElementContainer container = new ElementContainer();
            String fieldSetId = "identity-template";
            if (form2.getData() != null) {
                formContext.setCreation(form2.getData().isNew());
            }
            if (this.edition) {
                formContext.setFormSkippable(this.skippable);
                formContext.setElementToHideWhenSkipping(fieldSetId);
                form2.displayScripts(this.getOut(), formContext);
            }
            FieldSet fieldSet = new FieldSet();
            fieldSet.setID(fieldSetId);
            fieldSet.setClass("skinFieldset");
            Legend legend2 = new Legend(form2.getTitle());
            legend2.setClass("without-img");
            fieldSet.addElement((Element)legend2);
            String strForm = form2.toString(formContext);
            fieldSet.addElement(strForm);
            container.addElement((Element)fieldSet);
            container.output((Writer)this.getOut());
        }
    }

    protected JspWriter getOut() {
        return this.getJspContext().getOut();
    }

    private Form getForm(PagesContext pageContext) {
        PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
        return templateManager.getDirectoryForm(pageContext, !this.edition);
    }

    private PagesContext getFormContext() {
        PagesContext pageContext;
        if (Optional.ofNullable(User.getCurrentRequester()).filter(Predicate.not(User::isAnonymous)).isPresent()) {
            MainSessionController session = (MainSessionController)this.getJspContext().getAttribute("SilverSessionController", 3);
            pageContext = PagesContext.getDirectoryContext((String)this.userId, (String)session.getUserId(), (String)session.getFavoriteLanguage());
            if (StringUtil.isNotDefined((String)this.userId)) {
                pageContext.setDomainId(this.domainId);
                pageContext.setCreation(true);
            }
        } else {
            String userLanguage = Optional.ofNullable(this.getJspContext().getAttribute("userLanguage", 2)).filter(String.class::isInstance).map(String.class::cast).orElse(I18NHelper.DEFAULT_LANGUAGE);
            pageContext = PagesContext.getDirectoryContext(null, null, (String)userLanguage);
            RegistrationSettings registrationSettings = RegistrationSettings.getSettings();
            pageContext.setDomainId(registrationSettings.userSelfRegistrationDomainId());
        }
        return pageContext;
    }
}

