/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.session;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.web.session.SessionCloseable;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class HTTPSessionInfo
extends SessionInfo {
    private HttpSession httpSession;

    HTTPSessionInfo(HttpSession session, String ip, User ud) {
        super(session.getId(), ud);
        this.httpSession = session;
        this.setIPAddress(ip);
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public void onClosed() {
        if (this.httpSession != null) {
            this.cleanSession(this.httpSession);
            try {
                this.httpSession.invalidate();
            }
            catch (IllegalStateException ex) {
                SilverLogger.getLogger((Object)((Object)this)).info(ex.getMessage(), new Object[]{ex});
            }
        }
        super.onClosed();
    }

    private void cleanSession(HttpSession httpSession) {
        try {
            Enumeration attributeNames = httpSession.getAttributeNames();
            ArrayList<Object> controllers = new ArrayList<Object>();
            while (attributeNames.hasMoreElements()) {
                String spName = StringUtil.defaultStringIfNotDefined((String)((String)attributeNames.nextElement()));
                if (spName.startsWith("Silverpeas_") || spName.startsWith("WYSIWYG_")) {
                    controllers.add(httpSession.getAttribute(spName));
                }
                if (spName.startsWith("Redirect") || "gotoNew".equals(spName) || "Svp_Password_Change_Allowed".equals(spName) || "Svp_Pwd_About_To_Expire".equals(spName)) continue;
                httpSession.removeAttribute(spName);
            }
            this.cleanSessionControllers(controllers);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).error("Error while cleaning the HTTP session", (Throwable)e);
        }
    }

    private void cleanSessionControllers(List<Object> controllers) {
        for (Object element : controllers) {
            try {
                if (!(element instanceof SessionCloseable)) continue;
                ((SessionCloseable)element).close();
            }
            catch (Exception ex) {
                SilverLogger.getLogger((Object)((Object)this)).error("Error while cleaning the HTTP session in " + element.getClass().getSimpleName(), (Throwable)ex);
            }
        }
    }

    public <T> void setAttribute(String name, T value) {
        this.httpSession.setAttribute(name, value);
    }

    public void unsetAttribute(String name) {
        this.httpSession.removeAttribute(name);
    }

    public <T> T getAttribute(String name) {
        return (T)this.httpSession.getAttribute(name);
    }
}

