/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.publication.subscription.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.PublicationPath;
import org.silverpeas.core.contribution.publication.subscription.PublicationSubscriptionConstants;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.web.publication.subscription.bean.PublicationSubscriptionBean;
import org.silverpeas.core.web.subscription.bean.AbstractSubscriptionBean;
import org.silverpeas.core.web.subscription.bean.AbstractSubscriptionBeanService;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

@Service
public class PublicationSubscriptionBeanService
extends AbstractSubscriptionBeanService {
    @Override
    protected List<SubscriptionResourceType> getHandledSubscriptionResourceTypes() {
        return Stream.of(PublicationSubscriptionConstants.PUBLICATION, PublicationSubscriptionConstants.PUBLICATION_ALIAS).collect(Collectors.toList());
    }

    @Override
    public String getSubscriptionTypeListLabel(SubscriptionResourceType type, String language) {
        Optional<String> label = PublicationSubscriptionConstants.PUBLICATION.equals(type) || PublicationSubscriptionConstants.PUBLICATION_ALIAS.equals(type) ? Optional.of(this.getBundle(language).getString("GML.publications")) : Optional.empty();
        return label.orElse("");
    }

    @Override
    public List<AbstractSubscriptionBean> toSubscriptionBean(Collection<Subscription> subscriptions, String language) {
        OrganizationController controller = OrganizationController.get();
        ArrayList<AbstractSubscriptionBean> converted = new ArrayList<AbstractSubscriptionBean>();
        for (Subscription subscription : subscriptions) {
            SubscriptionResource resource = subscription.getResource();
            SubscriptionResourceType type = resource.getType();
            if (!PublicationSubscriptionConstants.PUBLICATION.equals(type) && !PublicationSubscriptionConstants.PUBLICATION_ALIAS.equals(type)) continue;
            String instanceId = resource.getInstanceId();
            controller.getComponentInstance(instanceId).ifPresent(i -> {
                ContributionIdentifier id = ContributionIdentifier.from((String)instanceId, (String)resource.getId(), (String)"Publication");
                SubscriptionSubscriber subscriber = subscription.getSubscriber();
                PublicationPath path = SubscriberType.GROUP == subscriber.getType() ? PublicationPath.getBestPathForGroup((ContributionIdentifier)id, (String)subscriber.getId()) : PublicationPath.getBestPathForUser((ContributionIdentifier)id, (String)subscriber.getId());
                converted.add(new PublicationSubscriptionBean(subscription, path, (SilverpeasComponentInstance)i, language));
            });
        }
        return converted;
    }

    @Override
    protected LocalizationBundle getBundle(String language) {
        return ResourceLocator.getGeneralLocalizationBundle((String)language);
    }
}

