/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.portlets.portal;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelState;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryContext;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.web.portlets.portal.PortletWindowData;
import org.silverpeas.kernel.util.StringUtil;

public class PortletWindowDataImpl
implements PortletWindowData,
Comparable,
Serializable {
    public static final long serialVersionUID = 1L;
    private String requestURL;
    private String portletWindowName;
    private String portletName;
    private String title;
    private CharSequence content;
    private boolean view;
    private boolean edit;
    private boolean help;
    private boolean remove;
    private Integer rowNumber;
    private String width;
    private String currentMode;
    private String currentWindowState;
    private String spaceId;
    private String role;

    @Override
    public void init(HttpServletRequest request, PortletRegistryContext portletRegistryContext, String portletWindowName) throws PortletRegistryException {
        String thePortletName = portletRegistryContext.getPortletName(portletWindowName);
        this.setPortletName(thePortletName);
        this.setPortletWindowName(portletWindowName);
        this.setRequestURL(request.getRequestURL());
        this.setView(portletRegistryContext.hasView(thePortletName));
        this.setEdit(portletRegistryContext.hasEdit(thePortletName));
        this.setHelp(portletRegistryContext.hasHelp(thePortletName));
        this.setRemove(true);
        this.setRowNumber(portletRegistryContext.getRowNumber(portletWindowName));
        this.setWidth(portletRegistryContext.getWidth(portletWindowName));
    }

    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    @Override
    public String getPortletName() {
        return this.portletName;
    }

    public void setPortletWindowName(String portletWindowName) {
        this.portletWindowName = portletWindowName;
    }

    public void setRequestURL(StringBuffer requestURL) {
        this.requestURL = requestURL.toString();
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    @Override
    public String getPortletWindowName() {
        return this.portletWindowName;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title2) {
        this.title = title2;
    }

    @Override
    public CharSequence getContent() {
        return this.content;
    }

    public void setContent(CharSequence content) {
        this.content = content;
    }

    @Override
    public boolean isView() {
        return this.view;
    }

    public void setView(boolean view) {
        this.view = view;
    }

    @Override
    public String getViewURL() {
        return this.getPortletModeURL(ChannelMode.VIEW.toString());
    }

    @Override
    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    @Override
    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    @Override
    public String getEditURL() {
        return this.getPortletModeURL(ChannelMode.EDIT.toString());
    }

    @Override
    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    @Override
    public String getHelpURL() {
        return this.getPortletModeURL(ChannelMode.HELP.toString());
    }

    @Override
    public boolean isNormalized() {
        String aCurrentWindowState = this.getCurrentWindowState();
        return ChannelState.NORMAL.toString().equals(aCurrentWindowState);
    }

    @Override
    public String getNormalizedURL() {
        return this.getPortletWindowStateURL(ChannelState.NORMAL.toString());
    }

    @Override
    public boolean isMaximized() {
        String aCurrentWindowState = this.getCurrentWindowState();
        return ChannelState.MAXIMIZED.toString().equals(aCurrentWindowState);
    }

    @Override
    public String getMaximizedURL() {
        return this.getPortletWindowStateURL(ChannelState.MAXIMIZED.toString());
    }

    @Override
    public boolean isMinimized() {
        String aCurrentWindowState = this.getCurrentWindowState();
        return ChannelState.MINIMIZED.toString().equals(aCurrentWindowState);
    }

    @Override
    public String getMinimizedURL() {
        return this.getPortletWindowStateURL(ChannelState.MINIMIZED.toString());
    }

    @Override
    public String getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(ChannelMode currentMode) {
        this.currentMode = currentMode == null ? ChannelMode.VIEW.toString() : currentMode.toString();
    }

    @Override
    public String getCurrentWindowState() {
        return this.currentWindowState;
    }

    public void setCurrentWindowState(ChannelState currentWindowState) {
        this.currentWindowState = currentWindowState == null ? ChannelState.NORMAL.toString() : currentWindowState.toString();
    }

    @Override
    public String getRemoveURL() {
        StringBuilder processURL = new StringBuilder(this.getRequestURL());
        processURL.append("?").append("dt.driverAction").append("=").append("RENDER").append("&").append("pc.portletMode").append("=").append(this.getCurrentMode()).append("&").append("pc.remove").append("=").append("true").append("&").append("pc.portletId").append("=").append(this.getPortletWindowName());
        if (StringUtil.isDefined((String)this.getSpaceId())) {
            processURL.append("&").append("dt.SpaceId").append("=").append(this.getSpaceId());
            if (StringUtil.isDefined((String)this.role)) {
                processURL.append("&").append("dt.Role").append("=").append("admin");
            }
        }
        return processURL.toString();
    }

    public void setRowNumber(Integer rowNumber) {
        this.rowNumber = rowNumber;
    }

    @Override
    public Integer getRowNumber() {
        return this.rowNumber;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    @Override
    public String getWidth() {
        return this.width;
    }

    @Override
    public boolean isThin() {
        return this.width != null && "thin".equals(this.width);
    }

    @Override
    public boolean isThick() {
        return this.width != null && "thick".equals(this.width);
    }

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    public void setSpaceId(String context) {
        this.spaceId = context;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    private String getPortletModeURL(String portletMode) {
        StringBuilder processURL = new StringBuilder(this.getRequestURL());
        processURL.append("?").append("dt.driverAction").append("=").append("RENDER").append("&").append("pc.portletMode").append("=").append(portletMode).append("&").append("pc.windowState").append("=").append(this.getCurrentWindowState()).append("&").append("pc.portletId").append("=").append(this.getPortletWindowName());
        if (StringUtil.isDefined((String)this.getSpaceId())) {
            processURL.append("&").append("dt.SpaceId").append("=").append(this.getSpaceId());
            if (StringUtil.isDefined((String)this.role)) {
                processURL.append("&").append("dt.Role").append("=").append("admin");
            }
        }
        return processURL.toString();
    }

    private String getPortletWindowStateURL(String portletWindowState) {
        StringBuilder processURL = new StringBuilder(this.getRequestURL());
        processURL.append("?").append("dt.driverAction").append("=").append("RENDER").append("&").append("pc.portletMode").append("=").append(this.getCurrentMode()).append("&").append("pc.windowState").append("=").append(portletWindowState).append("&").append("pc.portletId").append("=").append(this.getPortletWindowName());
        if (StringUtil.isDefined((String)this.getSpaceId())) {
            processURL.append("&").append("dt.SpaceId").append("=").append(this.getSpaceId());
            if (StringUtil.isDefined((String)this.role)) {
                processURL.append("&").append("dt.Role").append("=").append("admin");
            }
        }
        return processURL.toString();
    }

    public int compareTo(Object o) {
        Integer otherRowNumber = ((PortletWindowDataImpl)o).getRowNumber();
        int value = this.getRowNumber().compareTo(otherRowNumber);
        return value;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }
}

