/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.jstl.settings;

import javax.servlet.jsp.JspException;
import org.silverpeas.core.web.jstl.util.AbstractSetVarTagSupport;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class SettingsValueTag
extends AbstractSetVarTagSupport {
    private static final long serialVersionUID = 1L;
    private String key;
    private SettingBundle settings;
    private Object defaultValue;

    public void setSettings(String file) {
        this.settings = ResourceLocator.getSettingBundle((String)file);
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int doEndTag() throws JspException {
        if (StringUtil.isDefined((String)this.getVar())) {
            this.pageContext.setAttribute(this.getVar(), this.getValue(), this.getScope());
        }
        return 6;
    }

    private Object getValue() {
        if (this.defaultValue == null) {
            return this.settings.getString(this.key, (String)this.defaultValue);
        }
        if (this.defaultValue instanceof Boolean) {
            return this.settings.getBoolean(this.key, ((Boolean)this.defaultValue).booleanValue());
        }
        if (this.defaultValue instanceof Integer) {
            return this.settings.getInteger(this.key, ((Integer)this.defaultValue).intValue());
        }
        if (this.defaultValue instanceof Long) {
            return this.settings.getLong(this.key, ((Long)this.defaultValue).longValue());
        }
        if (this.defaultValue instanceof Float) {
            return Float.valueOf(this.settings.getFloat(this.key, ((Float)this.defaultValue).floatValue()));
        }
        return this.settings.getString(this.key, (String)this.defaultValue);
    }
}

